Reasoning Support for Risk Prediction and Prevention in Independent Living 7

| Relation Name      | Object                  | Reference Object Relation Type   |                              |
|--------------------|-------------------------|----------------------------------|------------------------------|
| personIn/personOut | Person                  | {Room,Area}                      | generic directional relation |
| in/out             | Area                    | Room                             | generic directional relation |
| Object             | {Room, Area}            |                                  |                              |
| near/far           | Person                  | Object                           | generic distance relation    |
| connected          | {Room,Area} {Room,Area} | generic directional relation     |                              |

all their ground instantiations. Grounders, such as *gringo* 2 and *lparse* 3, are capable of combining a problem encoding and a problem instance (typically a set of ground facts) into an equivalent ground program, which can then be then processed by one of the available ASP solvers. In our implementation of SINDI, answer set programs are grounded using Gringo (Gebser et al. 2007) and interpreted using the Clasp (Gebser et al. 2007) solver.

## 3 Knowledge Representation Model For The Home Healthcare Domain

Given that a well designed model is crucial to make effective reasoning possible, we carefully formalized SINDI's knowledge by using domain experts, published data and common-sense information.

The home healthcare domain is characterized by two main aspects: the context and the health assessment. These two aspects are strictly related in the home monitoring scenario, because the capability of identifying meaningful information about the context in which a person lives is a critical issue for health assessment via monitoring.

In this section we want to separately describe the knowledge representation model of SINDI in terms of these two domain aspects.

## 3.1 Model Of Context In Home Environments

While most of the implemented context-representation models are domain-dependent and do not support powerful inference, our declarative logic-based description of the domain aims at providing a representation of context-dependent data that is both general and with good computational properties. Other interesting properties of our logic-based solution are:

- *readability* and simplicity of the problem specification, - *flexibility* with respect to the sources of knowledge (heterogeneous sensors can be taken into account),