- *modularity* in the specification of the problem that describes properties of a desired solution, and
- *expressivity* of the modeling language and computational efficiency of the inference engines.

To fulfill these requirements, we use a high level description of home environments in terms of rooms, areas, objects, properties, relations and observations. The space is represented as a grid where each cell is identified by coordinates *X, Y* and has some properties (being in a room, being a wall, being a passage, etc.). The resulting context specification is then mapped into a set of logic predicates in the Answer Set Programming (ASP) framework (see Section 2 for details). In addition to the description of the model, a limited set of consistency constraints is introduced to make sure that observations and context interpretation are coherent. As an example, in the *localization* task, the person cannot be in a cell that has the property of being a wall. These constraints are also mapped into ASP.

Properties used in the model take into account generic spatial properties rather than describing geometric spatial relations between objects. This results in greater generality because we do not need a complete physical description of the environment. In addition, while data gathered by the sensors are processed and aggregated according to specific algorithms for feature analysis, the information available at upper levels is filtered by the abstraction. This enables us to represent meaningful information as properties of objects, rooms or areas, keeping the model independent of sensors' characteristics and positioning.

Our modelling approach is similar to what we would obtain by using an ontology, with the difference that the ASP reasoning enhances the expressivity and computational efficiency of the model. We are aware of the fact that research efforts are converging toward the combination of nonmonotonic reasoning and ontology-based knowledge representation, but available implementations are still domain dependent and formal issues need to be further explored. For this reason we decided to encode our contextual information directly into logic predicates, that can be easily mapped into an (existing or new) ontology if needed.

Previous investigation of context models has indicated that there are certain entities in a context that, in practice, are more important than others. These are location, identity, activity and time (Ryan et al. 1998; Schilit et al. 1994). In fact, in the context of home monitoring, the more intuitively relevant aspects of a context are: *where* you are, who you are (clinical profile), *which* resources you are using, what you are doing and *when*.

In order to represent this information in our model we identified four main types of entity: Person, Room, *Area* and *Object*.

We also define a small subset of generic spatial relations among entities, summarized in Table 14. An example of how a bedroom can be represented in our context model is illustrated in Figure 2.