A maximum point in the Hough space will correspond to the radius and center coordinates of the circle best defined by the edge points. Wildes et al. and Kong and Zhang also make use of the parabolic Hough transform to detect the eyelids, approximating the upper and lower eyelids with parabolic arcs, which are represented as; 
(-(x-hj)sin j + (y- kj ) cos j)
2 = aj((x-hj)cos j +(y kj)sin  Eq. (1) 
where aj controls the curvature, (hj, kj )is the peak of the parabola and j is the angle of rotation relative to the x-axis. 

In performing the preceding edge detection step, Wildes et al. bias the derivatives in the horizontal direction for detecting the eyelids, and in the vertical direction for detecting the outer circular boundary of the iris. The motivation for this is that the eyelids are usually horizontally aligned, and also the eyelid edge map will corrupt the circular iris boundary edge map if using all gradient data [12]. Taking only the vertical gradients for locating the iris boundary will reduce influence of the eyelids when performing circular Hough transform, and not all of the edge pixels defining the circle are required for successful localization. Not only does this make circle localization more accurate, it also makes it more efficient, since there are less edge points to cast votes in the Hough space.

## 2.2 Normalization

Once the iris region is successfully segmented from an eye image, the next stage is to transform the iris region so that it has fixed dimensions in order to allow comparisons. The normalization process will produce iris regions, which have the same constant dimensions, so that two photographs of the same iris under different conditions will have characteristic features at the same spatial location. We will be using Daugman's Rubber Sheet Model for normalization.

## 2.2.1 Daugman'S Rubber Sheet Model

Daugman suggested normal Cartesian to polar transformation that maps each pixel in the iris area into a pair of polar coordinates (r, θ), where r and θ are on the intervals of [0 1] and [0 2π] [2].

This unwrapping can be formulated as I(x(r, θ), y(r, θ)) I(r, θ) Such that x(r, θ) (1-r) xp(θ) + r x(θ) y(r, θ) (1-r) yp(θ) + r y(θ) 
where I(x, y), (x, y), (r, θ), (xp, yp), (xi, yi) represent the iris region, Cartesian coordinates, polar coordinates, coordinates of the pupil and iris boundaries along θ direction respectively. Thus this representation often called as rubber sheet model. 