propagation [17]. As a second example, many global constraints can be decomposed using ROOTS and RANGE which can themselves be propagated effectively using simple decompositions [18]. As a third example, the REGULAR and CFG constraints can be decomposed without hindering propagation [19, 20]. As a fourth example, decompositions of the SEQUENCE constraint have been shown to be effective [21]. Most recently, we demonstrated that the ALL-DIFFERENT and GCC constraint can be decomposed into simple primitive constraints without hindering bound consistency propagation [5]. These decompositions also introduced variables to count variables using values in an interval. For example, the decomposition of ALL-DIFFERENT ensures that no interval has more variables taking values in the interval than the number of values in the interval. Using a circuit complexity lower bound, we also proved that there is no polynomial sized SAT decomposition of the ALL-DIFFERENT constraint (and therefore of its generalizations like NVALUE) on which unit propagation achieves domain consistency [6].

Our use of "pyramid" variables is similar to the use of the "partial sums" variables in the encoding of the SEQUENCE constraint in [21]. This is related to the cumulative sums computed in [22].

## 9 Conclusions

We have studied a number of decompositions of the NVALUE constraint. We have shown that a simple decomposition can simulate the bound consistency propagator for NVALUE [12] with comparable time complexity but with a much greater space complexity. This supports the conclusion that the benefit of a global propagator may often not be in saving time but in saving space. Our other theoretical contribution is to show the first range consistency algorithm for NVALUE, that runs in O(nd3) time and O(nd2) space. These results are largely interesting from a theoretical perspective. They help us understand the globality of global constraints. They highlight that saving space may be one of the important advantages provided by propagators for global constraints. We have seen that the space complexity of decompositions of many propagators equals the worst case time complexity (e.g. for the ALL-DIFFERENT, GCC, AMONG, LEX,
REGULAR, CFG and SEQUENCE constraints). For global constraints like REGULAR,
the space complexity of the decompositions does not appear to be that problematic.

However, for global constraints like NVALUE, the space complexity of the decompositions is onerous. This space complexity seems hard to avoid. For example, consider encodings into satisfiability and unit propagation as our inference method. As unit propagation is linear in time in the size of the encoding, it is somewhat inevitable that the size of any encoding is the same as the worst-case time complexity of any propagator that is being simulated. One other benefit of these decompositions is that they help us explore the interface between constraint and integer linear programming. For example, we saw that an integer programming solver performed relatively well with these decompositions.

Acknowledgements. NICTA is funded by the Department of Broadband, Communications and the Digital Economy, and the ARC. Christian Bessiere is supported by ANR project ANR-06-BLAN-0383-02, and George Katsirelos by ANR UNLOC project: ANR 08-BLAN-0289-01. We thank Lanbo Zheng for experimental help.