# Symmetry Within And Between Solutions⋆ Toby Walsh

NICTA and University of NSW, Sydney, Australia, email: toby.walsh@nicta.com.au Abstract. Symmetry can be used to help solve many problems. For instance, Einstein's famous 1905 paper ("On the Electrodynamics of Moving Bodies")
uses symmetry to help derive the laws of special relativity. In artificial intelligence, symmetry has played an important role in both problem representation and reasoning. I describe recent work on using symmetry to help solve constraint satisfaction problems. Symmetries occur within individual solutions of problems as well as between different solutions of the same problem. Symmetry can also be applied to the constraints in a problem to give new symmetric constraints.

Reasoning about symmetry can speed up problem solving, and has led to the discovery of new results in both graph and number theory.

## 1 Introduction

Symmetry occurs in many combinatorial search problems. For example, in the magic squares problem (prob019 in CSPLib [1]), we have the symmetries that rotate and reflect the square. Eliminating such symmetry from the search space is often critical when trying to solve large instances of a problem. Symmetry can occur both *within* a single solution as well as *between* different solutions of a problem. We can also *apply* symmetry to the constraints in a problem. We focus here on constraint satisfaction problems, though there has been interesting work on symmetry in other types of problems (e.g. planning, and model checking). We summarize recent work appearing in [2,3,4].

## 2 Symmetry Between Solutions

A symmetry σ is a bijection on assignments. Given a set of assignments A and a symmetry σ, we write σ(A) for {σ(a) | a ∈ A}. A special type of symmetry, called solution symmetry is a symmetry *between* the solutions of a problem. More formally, we say that a problem has the *solution symmetry* σ iff σ of any solution is itself a solution [5].

Running example: The magic squares problem is to label a n by n *square so* that the sum of every row, column and diagonal are equal (prob019 in CSPLib [1]).

A normal *magic square contains the integers 1 to* n 2
*. We model this with* n 2
*variables* Xi,j *where* Xi,j = k iff the ith column and j*th row is labelled with the integer* k.

⋆
Supported by the Australian Government's Department of Broadband, Communications and the Digital Economy and the ARC. Thanks to the co-authors of the work summarized here:
Marijn Heule, George Katsirelos and Nina Narodytska.

arXiv:1007.0604v1 [cs.AI] 5 Jul 2010