"Lo Shu", the smallest non-trivial normal magic square has been known for over four thousand years and is an important object in ancient Chinese mathematics:

![0_image_0.png](0_image_0.png)

(1)
The magic squares problem has a number of solution symmetries. For example, consider the symmetry σd that reflects a solution in the leading diagonal. This map "Lo Shu" onto a symmetric solution:

![0_image_1.png](0_image_1.png)

$\eqref{eq:walpha}$. 
Any other rotation or reflection of the square maps one solution onto another. The 8 symmetries of the square are thus all solution symmetries of this problem. In fact, there are only 8 different magic square of order 3, and all are in the *same symmetry class.*
One way to factor solution symmetry out of the search space is to post symmetry breaking constraints. See, for instance, [6,7,8,9,10,11,12,13,14]. For example, we can eliminate σd by posting a constraint which ensures that the top left corner is smaller than its symmetry, the bottom right corner. This selects (1) and eliminates (2). Symmetry can be used to transform such symmetry breaking constraints [2]. For example, if we apply σd to the constraint which ensures that the top left corner is smaller than the bottom right, we get a new symmetry breaking constraints which ensures that the bottom right is smaller than the top left. This selects (2) and eliminates (1).

## 3 Symmetry Within A Solution

Symmetries can also be found within individual solutions of a constraint satisfaction problem. We say that a solution A *contains* the internal symmetry σ (or equivalently σ is a internal symmetry *within* this solution) iff σ(A) = A.

Running example: Consider again "Lo Shu". This contains an internal symmetry.

To see this, consider the solution symmetry σinv that inverts labels, mapping k *onto* n 2 + 1 − k. This solution symmetry maps "Lo Shu" onto a different (but symmetric)
solution. However, if we now apply the solution symmetry σ180 *that rotates the square* 180◦, we map back onto the original solution:

![0_image_2.png](0_image_2.png)

Consider the composition of these two symmetries: σinv ◦ σ180. As this maps "Lo Shu" onto itself, the solution "Lo Shu" contains the internal symmetry σinv ◦ σ180.

In general, there is no relationship between the solution symmetries of a problem and the internal symmetries within a solution of that problem. There are solution symmetries of a problem which are not internal symmetries within any solution of that