considers allocations where each player receives one continuous slice of cake. However, the definition of surjectivity could be easily extended to allocations where players can receive multiple slices. Our definition of surjectivity also ignores which player receives a particular slice. If an online cake cutting procedure is surjective, then there **is an arrival ordering of** the players and valuation functions such that any given player can receive a particular slice.

## 4.2 Scale Invariance

Players may have different scales for their valuation functions. Scale invariance indicates that this is unimportant. A cake cutting procedure is scale invariant **iff the allocation of**
cake is unchanged when a player's valuation is uniformly multiplied by a constant factor. It turns out that scale invariance is not difficult to achieve. Indeed, all **the online cake cutting** procedures we shall consider here are scale invariant.

## 4.3 Sequentiality

In some situations we may want cake to be cut from one end. This may **be the case, for** instance, when the cake represents time on a shared device. An onlike cake cutting procedure is sequential **iff the slice given to any player is to the left of any slice given to a player who** is later to depart.

## 4.4 Order Monotonicity

A player's allocation of cake typically depends on their arrival order. **We say that a cake** cutting procedure is order monotonic **iff a player's valuation of their cake does not decrease** when they are moved earlier in the arrival ordering (and all other players have the same arrival ordering). Note that as the moved player can receive cake **of greater value, players** who depart after them may now receive cake with less value. A positive interpretation of order monotonicity is that players are encouraged to participate as early as possible. On the other hand, players who have to arrive late may receive less value.

## 5 General Results

The fact that some players may depart before others arrive place **some fundamental limitations on the fairness of online cake cutting procedures.**
Theorem 1. No online cake cutting procedure is proportional, envy free **or equitable.**
Proof: **Suppose the procedure is proportional. Then every player is allocated some cake.**
As the cake cutting procedure is online, at least one player departs **before the final player**
arrives. Since the valuation function of the final player to arrive is not known when the first player departs, the cake allocated to the first player to depart cannot depend on the valuation function of the final player to arrive. Similarly, the valuation function of the final player to arrive cannot change who is the first player to depart. Consider the situation in which the final player to arrive has a valuation function that only values the cake allocated to the first player to depart. Whatever cake is allocated to the final player to arrive will be of no value to them. Hence the cake cutting procedure cannot be proportional.

Suppose the procedure is envy free. We consider the case where all players have valuation functions that assign some value to every slice. Every player is **allocated some cake**
otherwise they will envy the players who are allocated cake (and by assumption a cake cutting procedure must allocate cake to at least one player). As before, the cake allocated to the first player to depart cannot depend on the valuation function of the final player to 4