arrive. We now modify the valuation function of the last player to arrive so that the value of the cake remaining when the first player departs is 1 n2 **of the value it was before. Even if**
we allocate all the remaining cake to the last player to arrive, the value of this cake cannot now equal the value they assign to the cake allocated to the first player to depart. Hence the last player to arrive will envy the first player to depart. By a similar argument, the procedure cannot be equitable. ♥
Online cake cutting procedures can, however, possess many of the other properties.

Theorem 2. **Online cake cutting procedures can be forward proportional, forward envy free,**
weakly Pareto optimal, truthful, scale invariant, sequential and order monotonic.

Proof: **Consider the online cake cutting procedure which allocates all the cake to the first**
player to arrive. ♥
Unfortunately, allocating all the cake to one player is not very fair to the other players.

We therefore consider some specific online cake cutting procedures which divide the cake more equitably. It remains an important open problem to identify natural axioms that these procedures satisfy which are not satisfied by the trivial allocation of all cake to one player.

## 6 Online Cut-And-Choose

The cut-and-choose procedure for two players dates back to antiquity. It appears nearly three thousand years ago in Hesiod's poem Theogeny **where Prometheus divides a cow and** Zeus selects the part he prefers. Cut-and-choose is also enshrined in the United Nation's 1982 Convention of the Law of the Sea where it is put forward to divide the **seabed for mining.** In cut-and-choose, one player cuts the cake and the other takes the "half" that they most prefer. Cut-and-choose is proportional, envy free, Pareto optimal, weakly truthful, and surjective. However, it is not equitable, nor it is truthful.

We can use cut-and-choose as the basis of an online cake cutting procedure. The first player to arrive cuts the cake and waits for the next player to arrive. Either the next player to arrive chooses this piece and departs, or the next player to arrive declines this piece and the waiting player takes this piece and departs. If more players are **to arrive, the remaining** player cuts the cake and we repeat the process. Otherwise, the remaining player is the last player to be allocated cake and departs with whatever is left. We assume that all players know how many players will arrive.

Running Example:. **Suppose there are three players, the first player values only** [
1 2
, 1],
the second player values only [
1 3
, 1]**, and the third player values only** [0, 3 4
]**. We suppose**
that they uniformly value slices within these intervals. If **we operate the online version of**
cut-and-choose, the first player will arrive and cut off the slice [0, 2 3
] **as they assign this slice**
1 3 the total value of the cake. The second player then arrives. As they assign this slice with 1 2 the total value of the cake and they are only expecting 13 of the total, the second player is happy to take this slice and depart. The first player then cuts off the slice [
2 3
,
5 6
] **as they**
assign this 13 of the total value of the cake (and 12 of the value remaining after the second player departed with their slice). The third player then arrives. As they assign the slice [
2 3
,
5 6
]
with all of the total value of the remaining cake and they are only expecting 12 of whatever remains, the third player is happy to take this slice and depart. The first player now takes what remains, the slice [
5 6
, 1]**. It can be claimed that everyone is happy as the first player**
received a "fair" proportion of the cake, whilst the other two players received slices that were of even greater proportional value to them.

This online version of the cut-and-choose procedure has many (but not all) of the desirable properties described earlier.