the married people accept each other. It is known that all solutions of a SMI problem have the same size [3] (that is, number of married people). In SMT problems, instead, solutions are stable marriages where everybody is married.

Both of these variants are polynomial to solve. In real world situations, both ties and incomplete preference lists may be needed. Unfortunately, when we allow both, the problem becomes NP-hard [3]. In a SMTI (Stable Marriage with Ties and Incomplete lists) problem, there may be several stable marriages of different sizes, and solving the problem means finding a stable marriage of maximum size.

In this paper we investigate the use of a local search approach to tackle this problem. Our algorithm starts from a randomly chosen marriage and, at each step, moves to a neighbor marriage which is obtained by removing one blocking pair, that is, a man-woman pair who are not married to each other in the current marriage but who prefer to be married with each other rather than with with their current partners. Stable marriages have no blocking pairs, so the aim of such a move is to pass to a marriage which is closer to stability. Among the neighbor marriages, the evaluation function chooses one with the smallest number of blocking pairs and of singles. Since there may be several stable marriages with different sizes, we look for the one with maximum size
(that is, the smallest number of singles). Random moves are also used, to avoid stagnation in local minima. The algorithm stops when a perfect matching (that is, a stable marriage with no singles) is found, or when a given limit on the number of steps is reached.

This basic local search approach works well with problems of limited size, but does not scale. With large sizes, it fails to find good solutions and sometimes even stable marriages. One of the main reasons is that the neighborhood can be very large, since a marriage may have a large number of blocking pairs. Many such blocking pairs can be ignored since they are "dominated" by others, whose removal will also eliminate all the dominated blocking pairs. By considering only undominated blocking pairs, we can solve SMTI problems of much larger size in a small amount of time. The marriages returned by our local search method are stable and contain very few single people. Experiments on randomly generated SMTI problems of size 100 show that our algorithm is able to find stable marriages with at most two singles on average in tens of seconds at worst.

The SMTI problem has been tackled also in [4], where the problem is modeled as a constraint optimization problem and a constraint solver is employed to solve it. This systematic approach is guaranteed to find always an optimal solution. However, our experimental results show that our local search algorithm in practice always finds optimal solutions. Moreover, it scales well to sizes much larger than those considered in [4]. Instances of size comparable to ours are considered in [5]. However, the problem solved in that paper is the decision version of our optimization problem. That is, they ask if there exists a stable marriage of a certain size. Another approach is to use approximation. Given an SMTI problem, if its maximum cardinality stable marriage marriages are of size k, an α/β-approximation algorithm is able to return a stable marriage of size at least β/α · k. The SMTI problem cannot have and i-approximation algorithm for i