each search step, we move to a new marriage in the neighborhood of the current one. For each marriage M, the neighborhood N(M) is the set of all marriages obtained by removing one blocking pair from M. Consider a blocking pair bp =
(**m, w**) in M and assume m′ = M(w) and w
′ = M(m). Then, removing bp from M means obtaining a marriage M′in which m is married with w and both m′
and w
′ become single, leaving the other pairs in the marriage M unchanged.

Notice that, if M is stable, its neighborhood is empty. Notice also that this notion of neighborhood is not symmetric.

To select the neighbor to move to, we use an evaluation function f : Mn → Z,
where Mn is the set of all possible marriages of size n, and f(M) = nbp(M) +
ns(M). For each marriage M, nbp(M) is the number of blocking pairs in M,
while ns(M) is the number of singles in M which are not in any blocking pair.

The algorithm moves to a marriage M′ ∈ N(M) such that f(M′) ≤ f(M′′)
∀M′′ ∈ N(M).

During the search, the algorithm maintains the best marriage found so far, defined as follows: if no stable marriage has been found, then the best marriage is the one with the smallest value of the evaluation function; otherwise, it is the stable marriage with less singles.

To avoid stagnation in a local minimum of the evaluation function, at each search step we perform a random walk with probability p (where p is a parameter of the algorithm). In the random walk, we move to a randomly selected marriage in the neighborhood (we tried also to move to a generic random marriage, but this gave worse behavior). If a stable marriage is reached, its neighborhood is empty and a random restart is performed.

The algorithm terminates if a perfect marriage (that is, a stable marriage with no singles) is found, or when a maximal number of search steps is reached. Upon termination, the algorithm returns the best marriage found during the search.

The pseudo-code of our algorithm, called LTI, is shown in Algorithm 1. In the pseudo-code, Mbest is the best marriage found so far, and fbest its evaluation (number of blocking pairs plus number of singles). Function best **neighbor**
returns one of the best marriages in the neighborhood of the current marriage, according to the evaluation function.

In addition to this simple local search algorithm which directly applies standard local search approaches to SMTI problems, we have also designed a more sophisticated algorithm which has been tailored to exploit the specific features of SMTI problems. The main difference is in the definition of the neighborhood, which refers to the notion of undominated blocking pairs.

Definition 5 (Dominance in blocking pairs). Let (**m, w**) and (**m, w**′) be two blocking pairs. Then (**m, w**) dominates (from the men's point of view) (**m, w**′)
if m prefers w to w
′
. There is an equivalent concept from the women's point of view.

Definition 6 (Undominated blocking pair). A men- (resp., women-) undominated blocking pair is a blocking pair such that there is no other blocking