# A Unified View Of Automata-Based Algorithms For Frequent Episode Discovery

Avinash Achar Dept. of Electrical Engg.

Indian Institute of Science Bangalore 500080 India avinash@ee.iisc.ernet.in Srivatsan Laxman Microsoft Research Labs Sadashivanagar Bangalore 560080 India slaxman@microsoft.com

## P. S. Sastry Dept. Of Electrical Engg. Indian Institute Of Science Bangalore 560080 India Sastry@Ee.Iisc.Ernet.In Abstract

Frequent Episode Discovery framework is a popular framework in Temporal Data Mining with many applications.

Over the years many different notions of frequencies of episodes have been proposed along with different algorithms for episode discovery. In this paper we present a unified view of all such frequency counting algorithms. We present a generic algorithm such that all current algorithms are special cases of it. This unified view allows one to gain insights into different frequencies and we present quantitative relationships among different frequencies. Our unified view also helps in obtaining correctness proofs for various algorithms as we show here. We also point out how this unified view helps us to consider generalization of the algorithm so that they can discover episodes with general partial orders.

## 1. Introduction

Temporal data mining is concerned with finitely many useful patterns in sequential (symbolic) data streams [16]. Frequent episode discovery, first introduced in [14], is a popular framework for mining patterns from sequential data. The framework has been successfully used in many application domains, e.g., analysis of alarm sequences in telecommunication networks [14], root cause diagnostics from faults log data in manufacturing [22], user-behavior prediction from web interaction logs [11], inferring functional connectivity from multi-neuronal spike train data [19], relating financial events and stock trends [17], protein sequence classification [2], intrusion detection [12, 23], text mining [7], seismic data analysis [15] etc. The data in this framework is a single long stream of events, where each event is described by a symbolic event-type from a finite alphabet and the time of occurrence of the event. The patterns of interest are termed episodes. Informally, an episode is a short ordered sequence of event types, and a frequent **episode is one that occurs often enough in the given data sequence. Discovering frequent**
episodes is a good way to unearth temporal correlations in the data. Given a user-defined frequency threshold, the task is to efficiently obtain all frequent episodes in the data sequence.

An important design choice in frequent episode discovery is the definition of frequency of episodes. Intuitively any frequency should capture the notion of the episode occurring many times in the data and, at the same time, should have an efficient algorithm for computing the same. There are many ways to define frequency and this has given rise to different algorithms for frequent episode discovery [3, 6–
8, 13–15]. In the original framework of [14], frequency was defined as the number of fixed-width sliding windows over the data that contain at least one occurrence of the episode.

Another notion for frequency is based on the number of minimal **occurrences [13, 14]. Two frequency definitions called**
head frequency and total frequency **are proposed in [7] in**
order to overcome some limitations of the windows-based frequency of [14]. In [8], two more frequency definitions for episodes were proposed, based on certain specialized sets of occurrences of episodes in the data.

Many of the algorithms, such as the WINEPI of [14] and the occurrences-based frequency counting algorithms of [9, 10],
employ finite state automata as the basic building blocks for recognizing occurrences of episodes in the data sequence. An automata-based counting scheme for minimal occurrences has also been proposed in [4].

The multiplicity of frequency definitions and the associated algorithms for frequent episode discovery makes it difficult to compare the different methods. In this paper, we present a unified view of algorithms for frequent episode discovery under all the various frequency definitions . We present a generic automata-based algorithm for obtaining frequencies of a set of episodes and show that all the currently available algorithms can be obtained as special cases of this method.

This viewpoint helps in obtaining useful insights regarding the kinds of occurrences tracked by the different algorithms.

The framework also aids in deriving proofs of correctness for the various counting algorithms, many of which are not currently available in literature. Our framework also helps in understanding the anti-monotonicity conditions satisfied by different frequencies which is needed for the candidate generation step. Our general view can also help in generalizing current algorithms, which can discover only serial or parallel episodes, to the case of episodes with general partial orders and we briefly comment on this in our conclusions. The paper is organized as follows. Sec. 2 gives an overview of the episode framework and explains all the currently used frequencies in literature. Sec. 3 presents our generic algorithm and shows that all current counting techniques for these various frequencies can be derived as special cases.

Sec. 4 gives proofs of correctness for the various counting algorithms utilizing this unified framework. Sec. 5 discusses the candidate generation step for all these frequencies. In Sec. 6 we provide some discussion and concluding remarks.