set H, of non-overlapped occurrences of α in D is **maximal**
if |H**| ≥ |**H
′|**, where** H
′**is any other set of non-overlapped**
occurrences of α in D. The **non-overlapped frequency**
of α in D (denoted as fno**) is defined as the cardinality of a**
maximal non-overlapped set of occurrences of α in D.

Two occurrences are non-overlapped if no event of one occurrence appears in between events of the other. The notion of a maximal non-overlapped set is needed since there can be many sets of non-overlapped occurrences of an episode with different cardinality [8]. The non-overlapped frequency of γ in (1) is 2. A maximal set of non-overlapped occurrences is h(A, 2),(B, 3),(C, 8)i and h(A, 13),(B, 14),(C, 15)i.

Definition 6. [8] Two occurrences h1 and h2 of α are said to be non-interleaved if either th2(vj ) ≥ th1(vj+1), j = 1, 2, . . . N − 1 or th1(vj ) ≥ th2(vj+1), j = 1, 2**, . . . N** − 1.

A set of occurrences H of α in D is non-interleaved **if every pair of occurrences in the set is non-interleaved. A set**
H of non-interleaved occurrences of α in D is **maximal** if |H| ≥ |H′|, where H′**is any other set of non-interleaved**
occurrences of α in D. The **non-interleaved frequency**
of α in D (denoted as fni**) is defined as the cardinality of a**
maximal non-interleaved set of occurrences of α in D.

The occurrences h(A, 2),(B, 3),(C, 8)i and h(A, 7),(B, 9)(C, 12)i are non-interleaved (though overlapped) occurrences of (A →
B → C) in D. Together with h(A, 13),(B, 14),(C, 15)i**, these**
two occurrences form a set of maximal non-interleaved occurrences of (A → B → C) in (1) and thus fni **= 3.**
Definition 7. [8] Two occurrences h1 and h2 of α are said to be distinct **if they do not share any two events. A**
set of occurrences is distinct if every pair of occurrences in it is distinct. A set H **of distinct occurrences of** α in D is maximal if |H**| ≥ |**H
′|**, where** H
′**is any other set of distinct**
occurrences of α in D. The **distinct occurrences-based**
frequency of α in D (denoted as fd**) is the cardinality of a**
maximal distinct set of occurrences of α in D.

The three occurrences that constituted the maximal noninterleaved occurrences of (A → B → C**) in (1) also form a**
set of maximal distinct occurrences in (1).

The first frequency proposed in the literature was the windows based count [14] and was originally applied for analyzing alarms in a telecommunication network. It uses an automata based algorithm called WINEPI for counting. Candidate generation exploits the anti-monotonicity property that all subepisodes are at least as frequent as the parent episode. A statistical significance test for frequent episodes based on the windows-based count was proposed in [5]. There is also an algorithm for discovering frequent episodes with a maximum-gap constraint under the windows-based count [3].

The minimal windows based frequency and a level-wise procedure called MINEPI to track minimal windows were also proposed in [14]. This algorithm has high space complexity since the exact locations of all the minimal windows of the various episodes are kept in memory. Nevertheless, it is useful in rule generation. An efficient automata-based scheme for counting the number of minimal windows (along with a proof of correctness) was proposed in [4]. The problem of statistical significance of minimal windows was recently addressed in [21]. An algorithm for extracting rules under a maximal gap constraint and based on minimal occurrences has been proposed in [15].

In the windows-based frequency, the window width is essentially an expiry-time constraint (an upper-bound on the span of the episodes). However, if the span of an occurrence is much smaller than the window width, then its frequency is artificially inflated because the same occurrence will be found in several successive sliding windows. The head frequency measure, proposed in [7], is a variant of the windows-based count intended to overcome this problem.

Based on the notion of head frequency, [6] presents two algorithms MINEPI+ and EMMA. They also point out how head frequency can be a better choice for rule generation compared to the windows-based or the minimal windowsbased counts. Under the head frequency count, however, there can be episodes whose frequency is higher than some of their subepisodes (see [7] for details). To circumvent this, [7]
propose the idea of total frequency. Currently, there is no statistical significance analysis based on head frequency or total frequency.

An efficient automata-based counting algorithm under the non-overlapped frequency measure (along with a proof of correctness) can be found in [10]. A statistical significance test for the same is proposed in [9]. However, the algorithm in [10] does not handle any expiry-time constraints.

An efficient automata-based algorithm for counting nonoverlapped occurrences under expiry-time constraint was proposed in [8, 9] though this has higher time and space complexity than the algorithm in [10]. No proofs of correctness or statistical significance analysis are available for **nonoverlapped occurrences under an expiry-time constraint. Algorithms for frequent episode discovery under the non-interleaved**
frequency can be found in [8]. No proofs of correctness are available for these algorithms. Another frequency measure we discuss in this paper is based on the idea of distinct occurrences. No algorithms are available for counting frequencies under this measure. The unified view of automata-based counting that we will present in this paper can be readily used to design algorithms for counting distinct occurrences of episodes.

## 3. Unified View Of All The Automata Based Algorithms

In this section, we present a generic algorithm for obtaining frequencies of episodes under the different frequency definitions listed in Sec. 2.1. The basic ingredient in all the algorithms is a simple Finite State Automaton (FSA) that is used to recognize (or track) an episode's occurrences in the event sequence.

The FSA for recognizing occurrences of (A → B → C**) is**
illustrated in Fig. 1. In general, an FSA for an N**-node serial**
episode α = α[1] → α[2] → . . . → α[N] has (N **+ 1) states.**
The first N states are represented by a pair (i, α[i **+ 1]),**
i = 0, . . . N − 1. The (N + 1)th state is (N, φ) where φ **is a**
null symbol. Intuitively, if the FSA is in state (j, α[j **+ 1]),**
it means that the FSA has already seen the first j **event**
types of this episode and is now waiting for α[j **+ 1]; if we**
now encounter an event of type α[j **+ 1] in the data it can**
accept it (that is, it can transit to its next state). The start
(first) state of the FSA is (0, α[1]). The (N + 1)th **state is**
the accepting state because when an automaton reaches this