denote this as the NO-I algorithm and this is the algorithm proposed in [9].

In NO-I, if we only retire automata that reached their final states (rather than retire all automata except the one in the start state), we have an algorithm for counting minimal occurrences (denoted MO). In our example, the automata tracking h e 3, h e 4 and h e 6 **are the ones that reach their final**
states in this algorithm. The time-windows of these occurrences constitute the set of all minimal windows of α in D1.

Expiry time constraints can be incorporated by incrementing frequency only when the occurrence tracked has span less than the expiry-time threshold. The corresponding expirytime algorithm is referred to as MO-X.

The windows-based counting algorithm (which we refer to as WB) is also based on tracking earliest transiting occurrences. WB also uses multiple automata per episode to track minimal occurrences of episodes like in MO. The only difference lies in the way frequency is incremented. The algorithm essentially remembers, for each candidate episode, the last minimal window in which the candidate was observed.

Then, at each time tick, effectively, if this last minimal window lies within the current sliding window of width TX,
frequency is incremented by one. This is because, an occurrence of episode α exists in a given window w **if and only** w contains a minimal window of α.

It is easy to see that head frequency with a window-width of TX **is simply the number of earliest transiting occurrences**
whose span is less than TX**. Thus we can have a head frequency counting algorithm (referred to here as HD) that**
is similar to MO-X except that when two automata reach the same state simultaneously we do not remove the older automaton. This way, HD will track all earliest transiting occurrences which satisfy an expiry time-constraint of TX.

For TX = 10 and for episode α**, HD tracks** h e 3, h e 4, h e 5 and h e 6 **and returns a frequency count of 4. The total frequency**
count for an episode α **is the minimum of the head frequencies of all its subepisodes (including itself). This can be**
computed as the minimum of the head frequency of α and the total frequency of its (N − **1)-suffix subepisodes which**
would have been computed in the previous pass over the data. (See [7] for details). The head frequency counting algorithm can have high space-complexity as all the time instants at which automata make their first state transition need to be remembered.

The non-interleaved frequency counting algorithm (which we refer to as NI) differs from the minimal occurrence algorithm in that, an automaton makes a state transition only if there is no other automaton of the same episode in the destination state. Unlike the other frequency counting algorithms discussed so far, such an FSA transition policy will track occurrences which are not necessarily earliest transiting. In our example, until the event (A, **4) in the data**
sequence, both the minimal and non-interleaved algorithms make identical state transitions. However, on (A, **5), NI will** not allow the automaton in state (0, A**) to make a state** transition as there is already an active automaton for α in state (1, B) which had accepted (A, **4) earlier. Eventually,**
NI tracks the occurrences h ni 1 **= [1 3 7 15],** h ni 2 **= [4 9 16 18],**
h ni 3 **= [14 17 20 23] and** h ni 4 **= [19 21 25 29].**
While there are no algorithms reported for counting distinct occurrences, we can construct one using the same ideas.

Such an algorithm (to be called as DO) differs from the one for counting minimal occurrences, in allowing multiple automata for an episode to reach the same state. However, on seeing an event (Ei, ti**) which multiple automata can accept,**
only one of the automata (the oldest among those in the same state) is allowed to make a state transition; the others continue to wait for future events with the same event-type as Ei **to make their state transitions. The set of maximal**
distinct occurrences of α in D1 are h d 1 = h e 1, h d 2 **= [4 9 11 18],**
h d 3 **= [5 17 20 23],** h d 4 **= [14 21 25 29] and** h d 5 **= [19 24 30 31]**
which are the ones tracked by this algorithm.

We can also consider counting all **occurrences of an episode**
even though it may be inefficient. The algorithm for counting all **occurrences (referred to as the AO) allows all automata to make transitions whenever the appropriate events**
appear in the data sequence. However, at each state transition, a copy of the automaton in the earlier state is added to the set of active automata for the episode. From the above discussion, it is clear that by manipulating the FSA (that recognize occurrences) in different ways we get counting schemes for different frequencies. The choices to be made in different algorithms essentially concern when to initiate a new automaton in the start state, when to retire an existing automaton, when to effect a possible state transition and when (and by how much) to increment the frequency. We now present a unified scheme incorporating all this in Algorithm 1 **for obtaining frequencies of a set of serial**
episodes. This algorithm has five boolean variables, namely, TRANSIT, COPY-AUTOMATON, JOIN-AUTOMATON,
INCREMENT-FREQ and RETIRE-AUTOMATON. The counting algorithms for all the different frequencies are obtained from this general algorithm by suitably setting the values of these boolean variables (either by some constants or by values calculated using the current context in the algorithm).

Tables 2 - 6 specify the choices needed to obtain the algorithms for different frequencies. (A list of all algorithms is given in table 1). As can be seen from our general algorithm, when an event type for which an automaton is waiting is encountered in the data, the the automaton can accept it only if the variable TRANSIT is true. Hence for all algorithms that track earliest transiting occurrences, TRANSIT will be set to true as can be seen from table 2. For algorithms NI and DO where we allow the state transition only if some condition is satisfied. The condition COPY-AUTOMATON (Table 3) is for deciding whether or not to leave another automaton in the current state when an automaton is transiting to the next state. Except for NO and AO, we create such a copy only when the currently transiting automaton is moving out of its start state. In NO we never make such a copy (because this algorithm uses only one automaton per episode) while in AO we need to do it for every state transition. As we have seen earlier, in some of the algorithms, when two automata for an episode reach the same state, the older automaton is removed. This is controlled by JOIN-AUTOMATON, as given by Table 4. INCREMENT-FREQUENCY (Table 5) is the condition under which the frequency of an episode is incremented when an automaton reaches its final state. This increment is always done for algorithms that have no expiry time constraint or window width. For the others we increment the frequency only if the occurrence tracked satisfies the constraint. RETIRE-AUTOMATA condition (Table 6)
is concerned with removal of all automata of an episode when a complete occurrence has been tracked. This condition is true only for the non-overlapped occurrences-based counting