search, defined as follows: if no stable marriage has been found, then the best marriage is the one with the smallest value of the evaluation function; otherwise, it is the stable marriage with fewest singles.

The SML algorithm is therefore modified in the following ways:

- the evaluation function has to take into account that some person may be not married, so we use: f(M) = nbp(M)+ns(M), where, for each marriage M, ns(M) is the number of singles in M which are not in any blocking pair.

- When we remove a blocking pair (m, w) from a marriage M, their partners M(m) and M(w) become single.

- The algorithm performs a random restart when a stable marriage is reached, since its neighborhood is empty (because it has no blocking pairs).
We call LTIU the modified algorithm for SMTI problems, obtained from SML by the above modifications and by using undominated blocking pairs.

## 5 Experiments

We tested our algorithms on randomly generated sets of SM and SMTI instances. For SM problems, we generated stable marriage problems of size n using the impartial culture model
(IC) [5] which assigns to each man and to each woman a preference list uniformly chosen from the n! possible total orders of n persons. This means that the probability of any particular ordering is 1/n!.

For SMTI problems, we generated problems using the same method as in [4]. More precisely, the generator takes three parameters: the problem's size n, the probability of incompleteness p1, and the probability of ties p2. Given a triple (n, p1, p2), a SMTI problem with n men and n women is generated, as follows:

1. For each man and woman, we generate a random preference list of size n, i.e., a permutation of n persons; 2. We iterate over each man's preference list: for a man mi and for each women wj in his preference list, with probability p1 we delete wj from mi's preference list and mi from wj 's preference list. In this way we get a possibly incomplete preference list.

3. If any man or woman has an empty preference list, we discard the problem and go to step 1.

4. We iterate over each person's (men and women's) preference list as follows: for a man mi and for each woman in his preference list, in position j ≥ 2, with probability p2 we set the preference for that woman as the preference for the woman in position j − 1
(thus putting the two women in a tie).
Note that this method generates SMTI problems in which the acceptance is symmetric.

If a man m does not accept a woman w, m is removed from w's preference list as well. This does not introduce any loss of generality because m and w cannot be matched together in any stable marriage.

Notice also that this generator will not construct a SMTI problem in which a man (resp.,
woman) accepts only women (resp., men) who do not find him (resp, her) acceptable. Such a man (resp., woman) will remain single in every stable matching. A simple preprocessing step can remove such men and women from any problem, giving a smaller instance of the form constructed by our generator.