
## 6 Results On Sm Problems

We measured the performance of our algorithms in terms of number of search steps. For these tests, we generated 100 SM problems for each of the following sizes: 100, 200, 300, 400 and 500. In the following we show only the results of our best algorithm, which is SML2. We studied how fast SML2 converges to a stable marriage, by measuring the ratio between the number of blocking pairs and the size of the problem during the execution. Figure 2(a) shows that SML2 has a very simple scaling behavior. Let us denote by hbi the average number of blocking pairs of the marriage found by SML2 for SM problems of size n after t steps. Then the experimental results shown in Figure 2(a) have a very good fit with the function hbi = an22
−**bt/n**, where a and b are constants computed empirically (a ≈ 0.25 and b ≈ 5.7). Figure 2(a) shows that the analytical function hbi has practically the same curve as the experimental data. The figure shows also that the average number of blocking pairs, normalized by dividing it by n, decreases during the search process in a way that is independent from the size of the problem.

We can use function hbi to conjecture the runtime behavior of our local search method.

Consider the median number of steps, tmed, taken by SML2. Assume this occurs when half the problems have one blocking pair left and the other half have zero blocking pairs. Thus, hbi =
1 2
. Substituting this value in the equation for hbi, taking logs, solving for tmed, and grouping constant terms, we get tmed = cn(d + 2 log2(n)) where c and d are constants.

Hence, we can conclude that tmed grows as O(n log(n)).

We then fitted this equation for tmed to the experimental data (using c ≈ 0.26 and d ≈ −5.7). The result is shown in Figure 2(b), where we see that the experimental data have the same curve as function tmed. This means that we can use such an equation to predict the number of steps our algorithms needs to solve a given SM instance.

![0_image_0.png](0_image_0.png) 

## 6.1 Sampling The Stable Marriage Lattice

We also evaluated the ability of SML2 to sample the lattice of stable marriages of a given SM problem. To do this, we randomly generated 100 SM problems for each size between 10 and 100, with step 10. Then, we run the SML2 algorithm 500 times on each instance. To evaluate the sampling capabilities of SML2, we first measured the distance of the found stable marriages (on average) from the male-optimal marriage (the one that would be returned by the GS algorithm).