Given a SM problem P, consider a stable marriage M for P. The distance of M from Mm is the number of arcs from M to Mm in the Hasse diagram of the stable marriage lattice for P. This diagram can be computed in O(n 2 + n|S|) time [7], where S is the set of all possible stable marriages of a given SM instance. For each SM problem, we compute the average normalized distance from the male-optimal marriage considering 500 runs. Notice that normalizations is needed since different SM instances with the same size may have a different number of stable lattices. Then, we compute the average Dm of these distances over all the 100 problems with the same size, which is therefore formally defined as Dm =1 100 P100 j=11 500 P500 i=1 dm(Mi,Pj )
dm(Mi,Pj )+dw(Mi,Pj )
, where dm(Mi, Pj ) (resp., dw(Mi, Pj )) is the distance of Mi from the male (resp., female)-optimal marriage in the lattice of an SM Pj . If Dm = 0, it means that all the stable marriages returned coincides with the male-optimal marriage. On the other extreme, if Dm = 1, it means that all stable marriages returned coincide with the female-optimal one. Figure 3(a) shows that, for the stable marriages returned by algorithm SML2, the average distance from the male-optimal is around 0.5.

This is encouraging but not completely informative, since an algorithm which returns the same stable marriage all the times, with distance 0.5 from the male-optimal would also have Dm = 0.5. To have more informative results, we consider the entropy of the stable marriages returned by SML2. This measures the randomness in the solutions. Let f(Mi) be the frequency that SML2 finds a marriage Mi (for i in [1, |S|]) that is: f(Mi) = 1 500 P500 j=1 1Mi(j),
where 1Mi(j) is the indicator function that returns 1 if in the j-th execution the algorithm finds Mi, and 0 otherwise. The entropy E(P) for each SM instance P (i.e., for each lattice)
of size m is then: E(P) = −Pi=1∈{1..|S|} f(Mi) log2
(f(Mi)). In an ideal case, when each stable marriage in the lattice has a uniform probability of 1/m! to be reached, the entropy is log2(|S|) bits. On the other hand, the worst case is when the same stable marriage is always returned, and the entropy is thus 0 bits. As we want a measure that is independent from the problem's size, we consider a normalized entropy, that is E(P)/ log2
(|S|), which is in [0,1].

As we have 100 different problems for each size, we compute the average of the normalized entropies for each class of problems with the same size: En = 1 100 P100 i=1 E(Pi)/ log2
(|Si|),
where Siis the set of stable marriages of Pi.

Figure 3(b) shows that SML2 is not far from the ideal behavior. The normalized entropy starts from a value of 0.85 per bit at size 10, decreasing to just above 0.6 per bit as the problem's size grows.

![0_image_0.png](0_image_0.png) 

