# An Svm Multiclassifier Approach To Land Cover Mapping

Gidudu Anthony, Post Doctoral Fellow Hulley Gregg, Masters Student Marwala Tshilidzi, Professor School of Electrical and Information Engineering University of the Witwatersrand Johannesburg, Private Bag X3, Wits, 2050, South Africa Anthony.Gidudu@wits.ac.za, greghul@icon.co.za, Tshilidzi.Marwala@wits.ac.za

## Abstract

From the advent of the application of satellite imagery to land cover mapping, one of the growing areas of research interest has been in the area of image classification. Image classifiers are algorithms used to extract land cover information from satellite imagery. Most of the initial research has focussed on the development and application of algorithms to better existing and emerging classifiers. In this paper, a paradigm shift is proposed whereby a 'committee' of classifiers is used to determine the final classification output. Two of the key components of an ensemble system are that there should be diversity among the classifiers and that there should be a mechanism through which the results are combined. In this paper, the members of the ensemble system include: Linear SVM, Gaussian (Radial Basis Function) SVM and Quadratic SVM. The final output was determined through a simple majority vote of the individual classifiers. From the results obtained it was observed that the final derived map generated by an ensemble system can potentially improve on the results derived from the individual classifiers making up the ensemble system. The ensemble system classification accuracy was, in this case, better than the linear and quadratic SVM result. It was however less than that of the RBF SVM. Areas for further research could focus on improving the diversity of the ensemble system used in this research. Key Words: Ensemble Systems, Support Vector Machines, Land Cover Mapping

## Introduction

One of the means through which land cover classes can be extracted from satellite imagery is by the use of algorithms called image classifiers. Image classification may be categorized into supervised or unsupervised, parametric or nonparametric, contextual or noncontextual classification (Keuchela et al, 2003). This paper explores the use of nonparametric supervised classification algorithms called Support Vector Machines (SVMs). SVMs are nonparametric in the sense that they do not attempt to model the distribution of the training data, but try to separate the different classes by directly searching for adequate boundaries between them (Keuchel, 2003). This is unlike traditional classifiers such as maximum likelihood and minimum-distance-to-means classifiers which fall under the category of parametric classifiers. The interest in the exploration of new and emerging classifiers stems from the importance of land cover information to various disciplines such as forestry, precision agriculture, disaster management etc. How accurate a land cover map is derived has implications on how well the various application areas will be effected, be it at policy or operational level. Most of the current research in the area tends to focus on the application of new algorithms to land cover mapping with an emphasis on how they compare or if they are better than existing methods. In this paper a paradigm shift is proposed whereby instead of looking at which classifier is better than the traditional and/or emerging classifiers, there is an interest in how the classifiers can be considered collectively. The final land cover class assigned to a pixel is dependent on a vote between the 'committee' of classifiers. Hence the name - ensemble classifiers. This paper gives an overview on SVMs which are the subject of this paper. The paper then continues to highlight the issues pertaining to ensemble classification, the developed methodology and the results thereof. 