
## Support Vector Machines

SVMs, like other nonparametric classifiers such as Artificial Neural Networks, boast a robustness that has spearheaded its application into many areas. Having started off as a Statistical Learning Theory (Vapnik, 1995), SVMs have continued to be used in machine vision fields such as character, handwriting digit and text recognition 
(Vapnik, 1995; Joachims, 1998). More recently, their application to land cover mapping has been vigorously explored (Huang et al, 2002; Mahesh and Mather, 2003, Gidudu et al, 2007). Like other supervised classifiers, training data is a prerequisite to define the decision boundaries within the feature space, based upon which classification decision rules are made. For SVMs, this decision boundary is a linear discriminant placed midway between the classes of interest. Unfortunately, land cover classes when projected to the input space are rarely linearly separable. SVMs handle such datasets by nonlinearly projecting the training data in the input space to a feature space of higher (infinite) dimension by use of a kernel function. This results in the previously nonlinear datasets becoming linearly separable. Placing a linear discriminant in this high (infinite) dimension will be equivalent to placing a non linear discriminant in the previous input space. Some examples of functions (also called kernels) used to this effect include: polynomial, gaussian (more commonly referred to as radial basis functions) and sigmoid functions. Each function has parameters which have to be determined prior to classification and they are usually determined through a cross validation process. Operating in high dimension potentially renders the risk of overfitting in the input space possible. SVMs control this through the principle of Structural Risk Minimization (Vapnik, 1995). The empirical risk of misclassification is controlled by maximizing the margin between the training data and the decision boundary (Mashao, 2004). In practice this criterion is softened to the minimization of a cost factor involving both the complexity of the classifier and the degree to which marginal points are misclassified, and the tradeoff between these factors is managed through a margin of error parameter (usually designated C). Like the respective function parameters, this C parameter is tuned through cross-validation procedures (Mashao, 2004). Some of the classical literature relating to SVMs can be found in Vapnik (1995), Campbell (2000) and Christianini (2002). 

## Ensemble Classifiers

Ensemble systems come under different names such as multiple classifier systems, committee of classifiers or mixture of experts. The idea behind ensemble systems is to have the final classification result dependant on a pool of classifiers. Of importance to the generation of an ensemble system is that each individual classifier must be unique in how it generates decision boundaries (Polikar, 2006). The term used in ensemble systems is that there must be diversity in the ensemble system. The rational behind ensuring diversity is that each classifier will make a different error, and strategically combining these classifiers can reduce the total error (Parikh and Polikar, 2007). Some of the ways through which diversity can be ensured include: using different datasets to train different classifiers, using different training parameters for different classifiers, using different types of classifiers and using different features for the different classifiers (Polikar, 2006). Another key aspect about ensemble systems is how to combine the results from the individual classifiers. Two examples of common combination rules include simple majority and weighted majority A more theoretical treatise on ensemble systems can be found in Polikar (2006). Figure 1 gives a graphical illustration of an ensemble system. 

## Methodology

The study area for this research was extracted from a 2001 Landsat scene (row 171 and row 60). It refers to Kampala which is the capital of Uganda. The land cover classes of interest were water, built up areas, think swamps, light swamps and other vegetation. IDRISI Andes was used for the preliminary processing such as identification of training samples. These data were then exported to MATLAB (version 7) for SVM classification. The content of the ensemble system was: linear, RBF and a quadratic SVM. Given that the decision boundaries for these classifiers are different, it was assumed they would provide the requisite diversity. The final classification output was determined through a majority vote of the individual classifiers. The classification results were imported into IDRISI for georeferencing, GIS integration, derivation of land cover maps and accuracy assessment. 