
## 1 Introduction

1.1 Around 1990 Lewis A. Kornhauser and Lawrence G. Sager pointed out that collegial courts are liable to what they termed the doctrinal paradox
[*14, 15*]. A simple example of it would be the following: A person is on trial for having committed a crime. The case involves two issues p and q whose conjunction, i. e. both of them being true, determines whether the accused is guilty or not. The case is heard by a jury of three members. One of them believes that p is true but not q ; accordingly, he finds the accused not guilty.

Another one believes that q is true but not p; so he also finds the accused not guilty. Finally, the third member of the jury believes that both p and q are true, so he finds the accused guilty. Altogether, one can say that the jury has reached a majority verdict of not guilty. However, one can also say that they have a majority opinion that p is true and that q is also true; accordingly, the accused should be considered guilty. The above-mentioned authors acknowledge that "We have no clear understanding of how a court should proceed in cases where the doctrinal paradox arises" [15].

The main issue in a trial is whether the accused is guilty or not. Let t denote the proposition that he is guilty. We are assuming that this proposition is logically connected to p and q as specified by the following doctrine:
t ↔ p ∧ q . Every member of the jury is required to be consistent with it.

Therefore, there are only four consistent opinions about the truth of (*p, q, t*),
namely: (1, 1, 1), (1, 0, 0), (0, 1, 0) and (0, 0, 0), where 1 means true, and 0 means false. Let us consider all possibilities for a jury that is hearing such a case: let *x, y, z, u* be the fractions who adhere to, respectively, each of those four consistent opinions. In terms of these numbers, the fractions of the jury who believe in the truth of *t, p, q* are respectively vt = x, vp = x+y and vq = x + z . These numbers can be seen as degrees of collective belief in the truth of the respective propositions. A natural criterion for collectively deciding about t is to consider it true whenever vt >12
, i. e. x > 12
. In the following we will refer to it as the conclusion-based criterion . In contrast, the premise-based criterion considers t true if and only if both vp, vq >12
, i. e. both *x+y, x+z >* 12
. Clearly, if t is found true by the conclusion-based criterion, then it will also be found true by the premisebased one. However, the converse does not hold, as it is exemplified in the preceding paragraph, where vp = vq =
2 3 >
1 2 but vt =
1 3 <
1 2
.

1.2 The core of the problem is that the majority rule does not keep consistency with the doctrine. Even though each individual votes in a consistent way, the outcome of the majority rule need not be consistent! By the majority rule we mean accepting a proposition α and rejecting its negation α whenever vα >
1 2
.