From this point of view, the problem is entirely analogous to the wellknown paradox pointed out in the eighteenth century by the Marquis of Condorcet in connection with preferential voting [19]: When several individuals vote on three or more alternatives by ordering them according to their preferences, the majority rule may result in a cyclic (i. e. non transitive)
binary relation. In preferential voting one is interested in the propositions pxy : 'x is preferable to y ', where x and y vary over all possible pairs of alternatives, and the doctrine is transitivity, namely pxy ∧ pyz → pxz for any three alternatives *x, y, z* , together with asymmetry, namely pxy → pyx for any two alternatives *x, y* . As before, the problem is that the majority rule does not keep consistency with the doctrine. The standard example involves three alternatives *a, b, c* and three rankings, namely a  b  c, b  c  a and c  a  b. If vxy denotes the fraction of times that x is preferred to y ,
one gets vab = vbc = vca =
2 3 and vba = vcb = vac =
1 3
. Clearly, the condition vxy >
1 2 does not define a transitive relation.

Yet another class of objects whose aggregation and subsequent application of the majority rule may break away from the corresponding doctrine are equivalence relations. Consider, for example, the set {*a, b, c*} and the equivalence relations associated respectively with the three following partitions: {{a, b}, {c}}, {{a}, {*b, c*}} and {{*a, b, c*}}. If vxy denotes the fraction of times that x and y belong to the same class, one gets vab = vbc =
2 3 and vac =
1 3
(together with vyx = vxy ). Here too, the aggregation operation does away with transitivity.

All these problems are particular cases of a more general one where the objects being aggregated are systems of degrees of belief for several propositions which are logically constrained by a certain doctrine. This general problem can be referred to as that of constrained judgment aggregation.

In a celebrated paper published in 1952, Georges Th. Guilbaud already identified this problem as a generalization of Condorcet's one: "The general logic of propositions ... teaches us that the problem is universal. Given several propositions or questions, every logical relation between them can be expressed by establishing the list of possible arrangements of signs and the list of impossible arrangements. ... the rule of the majority may very well lead to a forbidden arrangement" [10]. 1.3 Condorcet's paradox is closely related to the celebrated impossibility theorem formulated in 1950–63 by Kenneth J. Arrow [*1, 9*]. This theorem is concerned with preferences expressed by means of complete rankings, ties allowed, and with rules for (deterministically) aggregating any given set of individual preferences of this form into a collective one of the same form. Quite naturally, one would be interested in rules that comply with the following con-