The remainder of this article is organized in five more sections: 2: Setting up the problem. 3: Construction and main results. 4: Technical issues and supplementary topics. 5: Application to specific domains. 6: Discussion and interpretation of the results.

## 2 Setting Up The Problem

In this section we introduce in more detail the objects that we will be dealing with. We will be definitely based upon propositional logic. However, instead of dealing with all-or-none truth assignments, we will deal with degrees of belief in the whole range from 0 to 1. The term 'belief' should be understood here in a very wide sense; depending on the context, it may be more appropriate to use other terms, such as 'plausibility', 'certainty',
'evidence', et cetera. On the other hand, we will also deal with decision values within a set of three alternatives meaning respectively 'accepted',
'rejected' and 'undecided'. Allowing for undecidedness is unavoidable as soon as one looks at aggregating different views on the same issues. Besides, the notion of aggregation also calls for allowing the degree of belief of a negation p to be independent from that of p. This leads to viewing p and p as antagonistic to each other but not necessarily mutually exclusive.

2.1 To begin with, we are interested in a finite set of basic propositions p, q, r, ... together with their respective negations p, q, *r, ...*. Following the standard terminology of logic, we will refer to *p, q, r, ...* as atoms, and an atom or its negation will be called a literal. The set of atoms will be denoted as Π+ , and the set of literals will be denoted as Π . So, Π = ∪p∈Π+ {p, p}.

A truth assignment is a mapping whereby each literal is assigned one of the values 'true' or 'false', with the restriction that p is false [resp. true]
whenever p is true [resp. false].

We will also deal with compound propositions. They are represented by formulas that combine atoms by means of the Boolean operators of propositional calculus, such as ¬, ∧, ∨,→ and ↔. We are assuming that ¬p = p and ¬(p) = p for any p ∈ Π+ . The notions of entailment —or logical implication— and logical equivalence between formulas will be understood exactly as in classical bivalent propositional logic: One formula entails another if there is no truth assignment that makes the first one true and the second one false according to the rules of propositional calculus. Two formulas are logically equivalent to each other when their truth value is the same for any truth assignment.