important on a river delta, where the whole ecosystem relies on the river water, while it is less important in an industrialized area.

## 4.1 Sensitivity Analysis

The simplex algorithm provides the optimal value of the objective function, the optimal assignment to the decision variables, and also other information that is of high interest for the decision maker. In particular, it provides the so-called reduced costs**, and the** *dual solution***. These indicators provide precious information on the**
sensitivity of the found solution to the parameters of the constraint model.

The dual solution is a set of values that correspond to the constraints. It can be thought of as the derivatives of the objective function with respect to the right hand side (RHS) of the constraints. This means that we immediately see, in the dual solution, which of the constraints are *tight***, i.e., which would change the value**
of the objective function if the RHS coefficient changes. For example, if we are optimizing the number fMW **of MW of electric power and we have a constraint**
rCO2 ≤ **limit**CO2
**, the corresponding dual value** dCO2

∂fMW
∂limitCO2 in the optimal solution answers the question: "How much would the production of energy decrease in case the limit of CO2 *lowers one point?"* **This is important information, since**
regulations change, and tend to become more strict.

The same analysis can be performed on the problem of optimizing some **(weighted**
sum of) receptors, given a total number of plants (or required MW). In this case, the dual value associated to a constraint represents how much the receptor will improve if that constraint is partially relaxed (if the RHS becomes less strict). For example, suppose we are optimizing the emissions of nitrogen oxides (NOx**), and we have**
the constraint (3) stating a limit on the total cost of the activities, **for example,** in euro. After obtaining the optimal value, the planner could ask: "Suppose now that we had more money: if I add one euro, how much would the emissions of NOx decrease?" The answer is the dual value de **of the constraint (3). This analysis is**
very attractive for the evaluator.

## 5 A Causal Model For Coaxial Matrices

In this section we consider an interpretation of Coaxial Matrices that differs from the one in Section 4. Instead of associating a real number to each activity, impact and receptor, we associate a Boolean random variable to each of them and we consider the interaction levels expressed in the matrix as probabilistic causal **dependencies.**
In this approach, we assume that an activity is either carried out or **not, an impact**
is either present or not and a receptor is either achieved or not. In **other words, we**
do not consider the magnitude or level of the variables under analysis. We used this approximation to get useful insights on the probabilistic modeling of the problem. In the future, we plan to consider more refined approximations with **multivalued** random variables or even continuous random variables.

Activities, impacts and receptors are represented by LPAD atoms (propositions)