2 *M. Gavanelli, F. Riguzzi, M. Milano and P. Cagnoli* Among the many possible applications of information technology to sustainable development, decision support systems represent a very important topic. Currently, environmental experts take decisions, perform evaluations and build plans manually, simply relying on experience, with little or no support from automated **tools.**
We believe the main reason why decision support systems are not widely applied in this field is twofold: first, despite significant advances in algorithmic **research,** the current state of decision support systems still faces severe **difficulties or cannot** cope at all with the highly complex structure of sustainability problems. Second, there is a lack of appropriate models for sustainability related applications. These models should be developed in tight collaboration between computer scientists and environmental scientists, economists and biologists that can provide not only models and data, but also feedback on system solutions.

Computational Logic can play a very important role in the design and implementation of decision support systems in this setting. First it enables a very intuitive and expressive representation of reality, and second it provides a number of reasoning mechanisms that can be successfully applied to the many aspects of **sustainability problems: logical inference, constraint reasoning and probabilistic reasoning. In**
addition, Computational Logic tools rely on a well-defined semantics, **and one can** reason on the program to give explanations of the obtained results **(or failure).**
Sustainable development encompasses three pillars: society, economy and the environment. In this paper, we focus particularly on the environment. We address the problem of defining a logic-based decision support system for Strategic Environmental Assessment (SEA), a legally enforced procedure aimed **to introduce systematic evaluation of the environmental effects of plans and programs. It typically**
applies to development, waste, transport, energy and land use plans, both regional and local, within the European Union. In this paper, we consider as a case study the assessment of Emilia Romagna regional plans. SEA is based on the **so-called**
coaxial matrices **that quantify dependencies between activities (e.g. infrastructures** and plants) contained in a plan and positive and negative environmental impacts (e.g., alteration of woods, water pollution), and dependencies between impacts and environmental receptors (e.g., quantity of CO2 **in the atmosphere).**
We propose two alternative logic-based approaches: one exploits Constraint Logic Programming on Real Numbers CLP(R**), and models coaxial matrices as sets of** linear equations and inequations; this is a simple, efficient model, that presumes the available information to be precise, and assumes that influences **can be summed** up. The second approach is based on Logic Programs with Annotated Disjunction (LPADs) where activities and impacts are combined using the laws of probability. We apply the two approaches on coaxial matrices referring to eleven types of plans that legally require the SEA. Experiments are performed on a real energy regional plan.

The structure of the paper is as follows: section 2 describes regional planning and Strategic Environmental Assessment along with coaxial matrices. **Section 3 recalls**
the main concepts behind constraint logic programming and probabilistic logic programming along with its causal interpretation. Section 4 shows the implementation of the coaxial matrices in CLP(R) while section 5 describes the approach based on