The coaxial matrices are currently used by environmental experts that manually evaluate a single, already defined, plan. A plan basically defines the so-called *magnitude* **of each activity: magnitudes are real values that intuitively express** *"how* much" **of an activity is performed. The unit is different for each activity: for example, for activity** *Thermoelectric power plants* **the magnitude says how many MW of**
electric power will be produced by thermoelectric plants, while the magnitude of Oil/gas/steam pipelines **gives the number of kilometers of pipes installed. A manual**
evaluation of alternatives and *what-if* **queries are very difficult to consider. In addition, planning is now carried out without a rigorous consideration of environmental**
aspects contained in the coaxial matrices.

In this paper, we propose two logic-based approaches for the design of a decision support system that can be used to assess a single, already defined plan, to evaluate different scenarios during the planning phase or to optimize the definition of land use activities and infrastructures.

In both cases, we convert the qualitative values into real numbers **in the interval**
[0, **1]. The environmental expert suggested the values to be 0.25 for** low**, 0.5 for**
medium**, and 0.75 for** *high*.

The first approach is based on Constraint Logic Programming on Real numbers (CLP(R**)), that is extremely efficient when dealing with linear equations. On**
the other hand, this approach does not take into consideration the subjective and stochastic nature of the available data: each value in the matrices is **simply used as**
a coefficient in a linear equation, so we assume that positive and negative impacts derived from planned activities can be summed. While in general, impacts can indeed be summed, in some cases a mere summation is not the most realistic relation and more sophisticated combinations should be considered.

For this reason, we also evaluate a Causal Probabilistic Logic Programming approach that is grounded on the well-established theory of probability and causality.

The same coefficients are now interpreted as probabilities, that will be combined through probability laws to provide the likelihood of a given receptor being affected.

The price to be paid is a higher computation time. A realistic decision support system should merge the two approaches and this is a subject of the current research activity.

## 3 Background

We provide some preliminaries on the two logic-based techniques used **in this paper.**

## 3.1 Constraint Logic Programming

Constraint Logic Programming (CLP) (Jaffar and Maher 1994) is a class of programming languages which extend classical Logic Programming. Variables can be assigned either terms (as in Prolog), or interpreted values, taken **from a** *sort***, that**
is a parameter of the specific CLP language. For example, we can have CLP(R)
(Jaffar et al. 1992), on the sort of real values, or CLP(FD), in which variables range on finite domains. The sort also contains interpreted functions (that, in numerical