domains, can be the usual operations +, -, ×**, etc.) and predicates (e.g.,** <, 6=, ≥,
etc.), which are called *constraints*. The declarative semantics gives the intuitive interpretation of the specific sort to constraints and interpreted terms: e.g., 1.3+2 < 5 is *true* in CLP(R**). The operational semantics resembles that of Prolog for atoms** built on the usual predicates (i.e., those predicates defined by a set **of clauses), but** stores the interpreted ones, the constraints, to a special data **structure, called the**
constraint store**. The store is then interpreted and modified by an external machinery, called the** *constraint solver***. The solver is able to check if the conjunction of**
constraints in the store is (un)satisfiable, and is also able to modify the store, possibly simplifying it to a refined state. Usually, the constraint solver does not perform complete **propagation: if it returns** *false***, then there is definitely no solution, but in** some cases it may fail to detect infeasibility even if no solution exists.

CLP(R) is the instance of CLP in which variables range on the reals. The available constraints are linear equalities and inequalities, and the solver is **usually implemented through the simplex algorithm, which is very fast and is complete for**
linear (in)equalities (it always returns true or *false***). Also, the user can communicate an** *objective function* **to the solver: a linear term that should be minimized or**
maximized while satisfying all constraints.

Many implementations of CLP(R**) exist nowadays (De Koninck et al. 2006), and**
many Prolog flavours (Zhou et al. 1996; Hermenegildo et al. 2008) have their own CLP(R) library. We decided to adopt ECLiPSe**, that features a library called** *Eplex*
(Shen and Schimpf 2005). This library interfaces ECLiPSe**to an external mixed**
integer linear programming solver, which can be either a state-of-the-art commercial one (like CPLEX or Xpress-MP), or an open source solver. By default, Eplex hides most of the details of the solver, but nevertheless, when required, the user can trim various parameters to boost the performance, and also inspect the internals of the solver. This feature becomes very useful in practical applications, and will be used to provide additional valuable information to the user, as detailed in Section 4.

## 3.2 Causal Probabilistic Logic Programming

In this section we first present Probabilistic Logic Programming and then we discuss how to model causation with it.

## 3.2.1 Probabilistic Logic Programming

The integration of logic and probability has been widely studied in Logic Programming and various languages semantics have been proposed, such as **Probabilistic**
Logic Programs (Dantsin 1991), Independent Choice Logic (Poole 1997), PRISM
(Sato and Kameya 1997), pD (Fuhr 2000), CLP(BN) (Santos Costa et al. 2003) and ProbLog (De Raedt et al. 2007).

Logic Programs with Annotated Disjunctions (LPADs) (Vennekens **et al. 2004)**
are particularly suitable for reasoning about causes and effects (Vennekens et al. 2009).

They extend logic programs by allowing clauses to be disjunctive and by annotating each atom in the head with a probability. A clause can be causally interpreted by