
## 1. Introduction

It is frequently claimed that integrating open world with closed world reasoning is a key issue for practical large-scale ontology applications. As one example, [Patel et al. 2007] describes a large medical case study about matching patient records for clinical trials criteria containing up to millions of assertions. In that clinical domain, open world reasoning is needed for radiology and laboratory data, because, for example, unless a lab test asserts a negative finding, no arbitrary assumptions about the test can be made. However, in pharmacy data, the closed world **assumption can** be used to infer that a patient is not on a specific medication unless it is **asserted.**
In general, both ontologies and rules provide distinct strengths for the representation and interchange of knowledge in the Semantic Web and for **applications**
of knowledge representation, such as the one described above. Expressive ontology languages are usually fragments of first-order logics represented in description logics (DLs) [Baader et al. 2007] and offer the deductive advantages of first-order logics with an open domain, while guaranteeing decidability. Rules on the **other**
hand offer non-monotonic (closed-world) reasoning that can be useful for formalizing scenarios under (local) incomplete knowledge. They also enable reasoning about fixed points (e.g., reachability), which cannot be expressed within first-order logic. Interest in ontologies, rules, and their combination is demonstrated by the development of ontology languages for the Semantic Web, such as OWL [Hitzler et al. 2009], and the growing interest on rule languages for the Semantic Web, cf.

the RIF [Boley and Kifer 2010] and the RuleML1**initiatives.**
The majority of proposals for combining rules and ontologies (see, e.g., related work in [Eiter et al. 2008; Knorr et al. 2011]) rely on one of the two most common semantics for rules: the Well-Founded Semantics (WFS) [van Gelder et al. 1991] or the Answer-Sets Semantics [Gelfond and Lifschitz 1991]. Both semantics are widely used and allow closed-world reasoning and the representation **of fixed points.** Furthermore, the relationship between the two semantics has been fully explored.

Of the two, the Well-Founded Semantics is weaker (in the sense that **it is more** skeptical w.r.t. derivable consequences), but it has the clear advantage that its lower complexity is more suitable for applications with large amounts of **data, such**
as the medical case study described above.

Several formalisms have concerned themselves with combining decidable DLs with WFS rules [Drabent and Ma luszy´nski 2007; Lukasiewicz 2010; **Eiter et al.** 2011; Knorr et al. 2011]. Among these, the well-founded semantics **for Hybrid**
MKNF knowledge bases (MKNFW F **), introduced first in [Knorr et al. 2008] and**
further refined in [Knorr et al. 2011], is based on a three-valued extension of the logics of minimal knowledge and negation as failure (MKNF) [Lifschitz 1991], and is the only one that allows knowledge about instances to be fully inter-definable between rules and an ontology that is taken as a parameter of the formalism.

MKNFW F **is defined using a monotonic fixpoint operator that computes in each**
iteration step, besides the usual immediate consequences from rules, the set of all atoms derivable from the ontology that is augmented with the already proven atomic knowledge. The least fixpoint of the MKNFW F **operator coincides with the**
ACM Transactions on Computational Logic, Vol. V, No. N, September 2018.