Each of the operations (1)–(9), in Definitions 4.5, 4.7, 4.11 and 4.14, **can be seen**
as a function that associates a forest with a new forest by adding a **new tree, adding** a new node to an existing tree, or marking a set of trees as complete. The only thing missing to complete the description of the procedure is the formalization of the initialization of an SLG(O) **evaluation, i.e., how the initial (DL-safe) conjunctive** query is defined.

Definition 4.15 Let Kd **be a doubled Hybrid MKNF knowledge base and let** q be a query of the form q(Xi) ← A1, . . . , An, not Bd 1
, . . . , not Bdm where Xi**is the**
(possibly empty) set of requested variables. We set F0 = {q(Xi) ←| q(Xi)} **to be**
the initial forest of an SLG(O) evaluation of Kdfor q and add q **itself to** Kd.

Of course, if the query is atomic we can simply start with the query itself, i.e.,
with the root containing the queried literal itself. Since the derivation uses Kd**(the**
doubled knowledge base), the technically correct way to query negative literals is to use not Bdinstead of not B for any atom B **which is why we use the doubled**
predicates for negative literals in the query.

Finally, note that if O represents an expressive DL, then O **may derive equalities**
between different individuals because the unique names assumption (UNA) is not applied. Hybrid MKNF accounts for that using the standard names assumption (see [Motik and Rosati 2010; Knorr et al. 2011]), thus adapting reasoning with equalities as well. As such, equalities allow us to derive further information in the sense that, for example, if C(a) and a ≈ b hold, then C(b) is derivable. If C(a**) is a**
DL-atom, then the DL reasoner of the oracle takes care of the problem internally. Only if C(a**) is a non-DL-atom, then we specifically have to query for equalities in**
O which is why Oracle Resolution **is not restricted to DL-atoms.**
In the next section, we show that SLG(O) **always terminates (Theorem 5.1)**
and, even though some orders of application of the possible operations are more efficient than others, that the procedure is confluent (Theorem 5.2). We also show that the procedure is sound and complete w.r.t. the well-founded MKNF model (Theorem 5.3) and that it is sound w.r.t. the semantics of two-valued **MKNF**
(Corollary 5.4). Finally, under some assumptions, we maintain the computational complexity of the bottom-up procedure (Theorem 5.7), which is actually an improvement since we do not have to consider the entire knowledge base but only the part relevant for a concrete query. But before showing these results, we finish the presentation of SLG(O) **with an example illustrating its behavior.**
Example 4.16 In order to illustrate the actions of SLG(O) **we consider a derivation of an answer to the query** discount(Bill) using a KB K **from [Motik and**
Rosati 2007]:17