Oracle Resolution **operations. As a result, the final forest can be seen as a**
residual program**: a sound transformation not only of the rules, but of information**
from the oracle, and can be used to construct a partial 2-valued stable model.19 Regarding complexity, it is clear that the complexity of the whole procedure SLG(O) **depends on the complexity of the oracle, and also on the number of** results returned by each call to the oracle. Clearly, the complexity **associated to the** computation of one result of the oracle function is a lower-bound of **the complexity of**
SLG(O)**. Moreover, even if the computation of one result of the oracle is tractable,** the (data) complexity of SLG(O) **may still be exponential if exponentially many**
solutions are generated by the oracle, e.g., if returning all supersets of a solution. This is so, because our definition of the oracle is quite general, and in order to prove interesting complexity results some assumptions must be made about the oracle.

We start by defining a correct partial oracle:
Definition 5.5 Let Kd = (O, Od,P
d**) be a doubled Hybrid MKNF knowledge**
base, S a goal, and L a set of ground atoms such that each L ∈ L **is unifiable** with at least one rule head in P
d(called program atoms). A partial oracle for O,
denoted pTO, is a relation pTO(IF , S,L) such that if pTO(IF , S,L**), then**

$\mathcal{O}\cup I_{\mathcal{F}}^{+}\cup\mathcal{L}\models S$ and $\mathcal{O}\cup I_{\mathcal{F}}^{+}\cup\mathcal{L}$ consistent; or,   $\mathcal{O}^{d}\cup I_{\mathcal{F}}^{+}\cup\mathcal{L}\models S$ and $\mathcal{O}^{d}\cup I_{\mathcal{F}}^{+}\cup\mathcal{L}$ consistent. 
A partial oracle pTO is correct w.r.t. compTO **iff, for all MKNF-consistent** Kd, replacing compTO in SLG(O) with pTO **succeeds for exactly the same set of queries.**
Note that the complete oracle is indeed generating unnecessarily many answers, and it can be replaced by a partial one that assures correctness. **E.g., consider a**
partial oracle that does not return supersets of other results. **Such a partial oracle**
is obviously correct. A further improvement on efficiency is the restriction to consistent sets O∪I
+
Fn

∪L and Od∪I
+
Fn

∪L**. If the knowledge base is MKNF-consistent,**
then looking for derivations based on inconsistencies is pointless anyway: we would just create a potentially large number of children none of which would **result in** an unconditional answer. In this sense, partial oracles are limited to meaningful derivations. In the case of an MKNF-inconsistent knowledge base, **things get a bit** more complicated.

Example 5.6 **Consider again the already doubled knowledge base from Example 3.13.**

Q ⊑ ¬R Qd ⊑ ¬R

d

| p(a) ← not p d (a)   | p d (a) ← not p(a) d (a) ← not NQ(a)   |
|----------------------|----------------------------------------|
| Q(a) ←               | Q                                      |
| d (a)                | R d (a) ← not R(a), not NR(a)          |
| R(a) ← not R         |                                        |

19**[Chen and Warren 1996] discusses these transformational aspects of SLG resolution, which are**
preserved in SLG(O), while the XSB manual discusses how the residual program can **serve as** input to an ASP solver.

ACM Transactions on Computational Logic, Vol. V, No. N, September 2018.