possible, albeit the oracle being the (polynomial complexity) bottom-up procedure that defines MKNFW F **. This approach is, however, somewhat counterproductive**
to the whole idea of a top-down querying mechanism: we could simply use the bottom-up procedure in the first place to compute the model and store the results in a database which we then query on demand. The following section defines a concrete oracle for the tractable description logic EL+ **that maintains the desired**
data complexity and retains goal-orientation.

## 6. An Oracle For El+

When defining an oracle on EL+ **we could simply try to use the algorithm for**
subsumption presented in [Baader et al. 2005]: reduce instance checking to subsumption and return the desired set of atoms which, when proven, **would ensure**
the derivability of the initial query. However, apart from the technical problems we would have to face, like how to obtain these sets of atoms whose truth allows us to prove the initial query, this would mean that we would have to run the entire subsumption algorithm for each query posed to the oracle in EL+.

We therefore proceed differently. We still use the algorithm for subsumption from
[Baader et al. 2005] to compute the complete class hierarchy of the EL+ **TBox** T ,
but we use it only once, as a kind of preprocessing of the ontology. Then we take the obtained results together with the TBox T **and simplify them by removing all**
statements that are redundant when looking for instances of classes in a top-down manner. The result, together with the EL+ ABox A**, is then turned into a set**
of rules which can be used in a top-down manner, by using SLG alone, yielding the desired oracle. Moreover, this way we can straightforwardly combine these transformed rules with the ones in the knowledge base and, with the **top-down** querying system defined in Section 4, obtain a single top-down procedure querying an MKNF knowledge base where the ontology is described in EL+.

## 6.1 Subsumption In El+

In [Baader et al. 2005], a polynomial time algorithm for subsumption was described, and we recall important notions from it, restricted to EL+. For a TBox T **, the**
notion BCT **represents the smallest set of concept descriptions that contains all** concept names used in T plus the top concept ⊤; while RT **denotes the set of all**
role names used in T **. Using this notation, a normalized form of a TBox** T is defined. Definition 6.1 [Baader et al. 2005] A TBox T is in **normal form** if

(1) all GCIs have one of the following forms, where C1, C2 ∈ BCT and D ∈
* $\mathsf{BC}_{\mathcal{T}}\cup\{\bot\}$: $$\begin{array}{ccccc}(1)&C_{1}\sqsubseteq D&(3)&\exists R.C_{1}\sqsubseteq D\\ (2)&C_{1}\sqcap C_{2}\sqsubseteq D&(4)&C_{1}\sqsubseteq\exists R.C_{2}\end{array}$$ * all RI are of the form $R\sqsubseteq S$ or $R_{1}\circ R_{2}\sqsubseteq S$
By appropriately introducing new concept and role names, any TBox T **can be** turned into normal form and, as shown in [Baader et al. 2005], this transformation ACM Transactions on Computational Logic, Vol. V, No. N, September 2018.