can be done in linear time. So, from now on, we assume that any TBox T **is in**
normal form.

The subsumption algorithm for EL+ **([Baader et al. 2005]) applies a set of completion rules to compute the entire class hierarchy, i.e. all subsumption relationships**
between all pairs of concept names occurring in T **. In detail, given a normalized** TBox T **, the algorithm computes:**
—a mapping S from BCT to a subset of BCT ∪ {⊥}**; and**
—a mapping T from RT **to a binary relation on** BCT .

These mappings make implicit relations explicit in the following sense:
(I1). D ∈ S(C**) implies that** C ⊑ D,
(I2). (C, D) ∈ T (R) implies that C ⊑ ∃R.D.

The initialization of these mappings is the following:
—S(C) := {C, ⊤} **for each** C ∈ BCT
—T (R) := ∅ **for each** R ∈ RT
Then the following completion rules are applied to extend S and T **until no more**
rule applies.

CR1 If C
′ ∈ S(C), C
′ ⊑ D ∈ T **, and** D 6∈ S(C)
then S(C) := S(C) ∪ {D}
CR2 If C1, C2 ∈ S(C), C1 ⊓ C2 ⊑ D ∈ T **, and** D 6∈ S(C)
then S(C) := S(C) ∪ {D}
CR3 If C
′ ∈ S(C), C
′ ⊑ ∃R.D ∈ T , and (**C, D**) 6∈ T (R)
then T (R) := T (R) ∪ {(**C, D**)}
CR4 If (C, D) ∈ T (R), D′ ∈ S(D), ∃R.D′ ⊑ E ∈ T **, and** E 6∈ S(C)
then S(C) := S(C) ∪ {E}
CR5 If (C, D) ∈ T (R), ⊥ ∈ S(D), and **⊥ 6∈** S(C)
then S(C) := S(C) **∪ {⊥}**
CR6 If (C, D) ∈ T (R), R ⊑ S ∈ T , and (**C, D**) 6∈ T (S)
then T (S) := T (S) ∪ {(**C, D**)}
CR7 If (C, D) ∈ T (R1), (D, E) ∈ T (R2), R1 ◦ R2 ⊑ R3 ∈ T , and (**C, E**) 6∈ T (R3)
then T (R3) := T (R3) ∪ {(**C, E**)}
Note that we omitted the four completion rules related to nominals and concrete domains.

It is shown in [Baader et al. 2005] that this algorithm terminates in polynomial time and that it is correct.

## 6.2 Simplifying The Ontology

Given a normalized EL+ TBox T (Definition 6.1) and an EL+ ABox A**, the first**
step in transforming the ontology is to apply the subsumption algorithm to T and obtain the mappings S and T computed by it. In particular, we obtain via S all the subsumption relationships implicitly or explicitly present in C**. In fact, it is**
easy to see that the initialization of C ∈ S(C) for each C ∈ BCT **ensures that**
ACM Transactions on Computational Logic, Vol. V, No. N, September 2018.