fact that if an atom is proven false in the ontology, then its negation **also holds in**
the rules. Note that this is achieved in SLG(O) **by querying for classically negated** atoms, but these are outside the syntax of REL **even though a restricted form of** negation is achievable via ⊥.

Regarding inconsistencies, there are two kinds which can appear in the threevalued Hybrid MKNF semantics as presented in [Knorr et al. 2011]: either the ontology alone is inconsistent, or there is an inconsistency resulting **from contradictory derivations in the rules and the ontology. In the first case, there is not much**
to be done. An inconsistent ontology has no models and we can simply derive anything from it, making reasoning over a combined knowledge base rather pointless.

We therefore admit in the following an a-priori consistency check of **the ontology**
alone, and proceed only if it succeeds, i.e., we limit ourselves in the following to a consistent ontology.21 **For the second case, the bottom-up computation allows us to**
detect such problems, but in SLG(O) **we are limited to finding atoms that are true** and false at the same time, i.e., if for some C(a) both queries C(a) and not C
d(a)
22 are answered with 'yes', then the combined KB is inconsistent. This can, of course, not be complete for a partial oracle, as shown in Example 5.6, so that **we obtain a** paraconsistent behavior. To carry over this behavior to a transformation into rules, we have to take into consideration the transformation presented **in Definition 3.4**
and their effect on the EL+ KB.

Regarding classical negation, we solve the problem in a specific way. In **SLG(**O),
the special negative literals not NH(ti) are used to call ¬H(ti**). Since this is not**
expressible in EL+ we simply consider not NH(ti**) as normal negative literals, and**
transform O into rules such that not NH(ti) holds if ¬H(ti**) holds. More precisely,** if H ⊑ ⊥, then NH(ti**) holds.**
We are now ready to define the transformation of the ontology O **consisting of a**
reduced T Box **and an ABox into a set of already doubled rules (see Definition 3.1).**
Definition 6.6 Let K = (O,P) be a Hybrid MKNF knowledge base with a consistent EL+ KB O**. We define** P
d O from O, where C,D, C1, and C2 **are concept**
names, R, S, T are role names, and a, b **are individual names, as the smallest set** containing:
(a1). for each C(a) ∈ A: C(a) ← and C
d(a) ← not NC(a).

(a2). for each R(a, b) ∈ A: R(a, b) ← and Rd(a, b) ← not NR(**a, b**).

(c1). for each GCI C ⊑ D ∈ T : D(x) ← C(x**) and**
Dd(x) ← C
d(x), not ND(x).

(c2). for each C1 ⊓ C2 ⊑ D ∈ T : D(x) ← C1(x), C2(x**) and**
Dd(x) ← C
d 1(x), Cd 2(x), not ND(x).

(c3). for each ∃R.C ⊑ D ∈ T : D(x) ← R(x, y), C(y**) and**
Dd(x) ← Rd(x, y), Cd(y), not ND(x).

(r1). for each RI R ⊑ S ∈ T : S(x, y) ← R(x, y**) and**
S
d(x, y) ← Rd(x, y), not NS(**x, y**).

21Note that ontologies in EL+ can in fact be inconsistent: consider a GCI C ⊑⊥ **in the TBox and**
an assertion C(a**) in the ABox.**
22**Recall that we use the doubled predicate for determining falsity.**
ACM Transactions on Computational Logic, Vol. V, No. N, September 2018.