Definition 2.3 An MKNF rule r is DL-safe if every variable in r **occurs in at least**
one (positive) non-DL-atom in the body of r**. A Hybrid MKNF knowledge base** K is DL-safe **if all its rules are DL-safe.**
A DL-safe conjunctive query q **is a non-empty set, i.e., conjunction, of literals**
where each variable in q occurs in at least one (positive) non-DL-atom in q**. We also**
write q as a rule q(Xi) ← A1, . . . , An, not B1, . . . , not Bm where Xi**is the (possibly**
empty) set of variables, appearing in the body. This restriction of conjunctive queries to DL-safety is not always necessary: for DLs like SHIQ, conjunctive query answering is decidable [Glimm et al. 2008] and we may make use of existing algorithms. However, for DLs where there is no known algorithm for conjunctive query answering or where the problem is not decidable, such as full EL++ **[Rosati 2007], the limitation is required to achieve decidability**
in Hybrid MKNF knowledge bases. For simplicity of presentation, we impose the restriction throughout the paper.

Example 2.4 We present a small technical example to illustrate the notions introduced in this section. Consider the Hybrid MKNF knowledge base K **consisting**
of an EL+ KB O **containing two TBox statements and one assertion and a set of**
MKNF rules. Here and in the following examples we follow the convention **that** DL-atoms are capitalized, while non-DL-atoms start with lower case **letters.**

$\mathbb{C}\sqsubseteq\mathbb{D}$? 
C ⊑ D C(b)

| C ⊓ E ⊑ ⊥ p(x) ← not D(x), o(x)   | o(a) ←   |
|-----------------------------------|----------|
| E(x) ← not E(x), o(x)             | o(b) ←   |

The ground instantiation KG is obtained by grounding both rules with a and b.

Note that the atom o(x**) ensures that both (non-ground) rules are DL-safe.**

## 2.3 Well-Founded Semantics Of Hybrid Mknf Knowledge Bases

In this section, we recall the computation of the well-founded MKNF **model from**
[Knorr et al. 2011].7 **We adopt that terminology here and recall the notions relevant**
for its definition. First, we present some notions from [Knorr et al. 2011] that are useful in the definition of the operators for obtaining that well-founded MKNF model.

Definition 2.5 Let K = (O,P**) be a ground Hybrid MKNF knowledge base. The** set of known atoms of K, KA(K**), is the smallest set that contains (i) all positive**
literals occurring in P, and (ii) a positive literal ξ for each negative literal not ξ 7**The well-founded MKNF semantics including the well-founded MKNF model, as presented in**
[Knorr et al. 2011], is based on a complete three-valued extension of the original MKNF semantics of [Motik and Rosati 2010]. In it, a model consists of two sets **of sets of first-order interpretations;** a 3-valued truth valuation is defined that exactly determines the semantics, and in which any MNKF formula can be evaluated. However, as here we are only interested in queries that are
(conjunctions of) atoms, we limit ourselves to the computation of the literals that are true and false. This is called the well-founded partition in [Knorr et al. 2011] but we term it the well-founded MKNF model here.

ACM Transactions on Computational Logic, Vol. V, No. N, September 2018.