
## 7 Extending Fp2 With Odd-Cycles

By Lemma 4.4, FP2 programs cannot be inconsistent nor express denials (that require oddcycles). This restriction can be relaxed simply by composing FP2 programs with argument restricted programs (Lierler and Lifschitz 2009), that are currently the largest known decidable class of programs with the *persistent CFSP property* and have no restriction on odd-cycles.

Definition 7.1
(Baselice and Bonatti 2008) A class of programs C has the *computable finite semantics* property (CFSP for short) iff (i) for all P in C, P has finitely many stable models each of which is finite, and (ii) there exists a computable function f mapping each member of C onto its set of stable models. Moreover, the CFSP property is *persistent* iff C is closed under language extensions (i.e., adding more constants or function symbols to the language of a program P ∈ C yields another program in C).

The CFSP property abstracts a number of program classes with function symbols: ωrestricted programs (Syrj¨anen 2001), λ-restricted programs (Gebser et al. 2007), argument restricted programs, and more generally the semidecidable class of finitely-ground programs (Calimeri et al. 2008). The persistent CFSP property is important because, under suitable hypotheses, programs with this property can be composed with finitary programs without affecting the decidability of inference (Baselice and Bonatti 2008). We need a preliminary result:
Proposition 7.2 Argument restricted programs have the persistent **CF SP**.

The forms of composition studied in (Baselice and Bonatti 2008) are the following. Let Def(P) denote the set of predicates *defined in* P, that is, the set of all predicate symbols occurring in the head of some rule in P. Let Called(P) be the set of predicates *called by* P, that is, the set of all predicate symbols occurring in the body of some rule in P. Then we say that P1 *depends on* P2, in symbols P1 ✄ P2, if and only if Def(P1) ∩ Def(P2) = ∅ , Def(P1) ∩ Called(P2) = ∅ , Called(P1) ∩ Def(P2) 6= ∅ .

Moreover, P1 and P2 *are independent*, in symbols P1kP2, if and only if Def(P1) ∩ Def(P2) = ∅ , Def(P1) ∩ Called(P2) = ∅ , Called(P1) ∩ Def(P2) = ∅ .

Now the techniques of (Baselice and Bonatti 2008), based on the splitting theorem, can be easily adapted to prove the following result:
Theorem 7.3 For all programs P and Q such that P is in FP2 and Q has the persistent CFSP, if P ✄ Q
or PkQ, then both credulous and skeptical consequences from P ∪ Q are decidable.

In particular, this result shows that it is theoretically possible to add the expressiveness of FP2 programs to argument restricted (actually, all finitely ground) programs.