
## 2. **Model Construction**

Traditional wisdom uses a "low risk / high consequence" strategy for taking security measures. But experience has shown it is not the only and sometimes **not even the best**
counter terror strategy. Scarce resources can be better exploited if a way is found to predict threats according to likelihood, and not just according to the severity of consequences.

Explicitly, a model which attempts to predict suicide attacks should cater for following aspects:
1. Estimate the "attractiveness" of specific cities to terrorist organizations, 2. Identify vulnerabilities to build a portfolio of possible attack locations, and 3. Enable decision makers to concentrate resources on most probable targets.

Construction of a decision making model under the conditions peculiar to suicide attacks should cater both the aspects of information incompleteness and expert's usage of linguistic variables. Linguistic variables are best dealt with Fuzzy Set Theory of Zadeh [14] and information incompleteness is handled by Soft Set Theory of **Molodtsov [9]. Both** these aspects have been combined in theory of Fuzzy Soft Sets by **Maji, Biswas and Roy** [8].

We, therefore, proceed first to identify the main factors which in expert opinion may contribute towards the selection of target city by suicide attackers. In the second phase we develop a selection algorithm which takes advantage of the in-built **mechanism for** quantization of value judgements of counter-terror experts. 2.1. Potential Factors for Decision Making. **Understanding of the terrorist's**
target-selection criterion would help us to identify the potential terror attack locations. Therefore, our assessment of which targets are most attractive must be made from the point of view of the terrorist. We enlist following factors to be considered for making a decision:
1. Maximize the number of casualties: **Their main aim is mass killing and destruction, without regard for their own life or the lives of others. Thus the cities**
with high population density are more prone to such attacks.

2. Damage to the civil/military infrastructure: **As the terrorists aim to weaken**
the civil/military infrastructure or at least they attempt to create **an impression**
that such infrastructures have been subjugated by and large, cities with high concentration of government structures, stand more possibility of attack. To cause such damage of infrastructure, an all alone suicide attack, where **a single terrorists** explodes himself among masses, is seldom the choice. Instead a variant of suicide attack known as Vehicle-borne improvised explosive device (VBIED) **is employed.** Typically it is based on a car containing several dozen kilograms or several hundred pounds of explosives (mostly ANFO= ammonium nitrate, diesel oil plus **a small** booster charge). Truck bombs carrying a larger load of explosives, notably vehicles with up to 8t **of explosives on board have already been detonated. The vehicle is**
parked near an area with increased population density (marketplace, shopping center, office building) or driven at high speed against the target (e.g. checkpoint) and