Definition 4.5 Let P1, P2 be logic programs. X is an answer set of P1 ∗ P2 if:
1. there is a 3-valued answer set X2 of P2 **and,** 2. for some P ∈ P1 ↓(P2 ∪ P gm(X2)), X **is an answer set of** P.

## 4.1 Examples

Consider the examples given earlier. For Example 3.1 we have:

$$\begin{array}{r c l}{P_{1}}&{=}&{\{b\leftarrow,\ c\leftarrow\ n o t\ d\}}\\ {P_{2}}&{=}&{\{a\leftarrow\ n o t\ b\}}\end{array}$$

For P1 ∗ P2 **we obtain:**

$P_{2}^{r}=P_{2}$, $X_{2}=(\{a\},\{b\})$  $P_{1}^{r}=\{c\gets not\ d\}\cup\{a\gets,\ \bot\gets b\}$, $X_{1}=(\{a,c\},\{b,d\})$.  
Thus, P2 has 3-valued answer set ({a}, {b}) - {a} **is a (standard) answer set for** P2, and it depends on, at minimum, the assumption of b **being false by default. This**
in turn requires a commitment to the non-truth of b in next considering P1**. The**
program P
r 1 given by rules of P1 consistent with ({a}, {b}**) consists of the single**
rule c ← not d **along with an encoding of the 3-valued interpretation (**{a}, {b}).

We obtain the 3-valued answer set ({a, c}, {b, d}**), with corresponding answer set** {a, c}. This shows that a fact, in this case b**, may be withdrawn without its negation** ¬b **being asserted. We elaborate on this point in the context of an overall revision** methodology in Section 5.

Consider next Example 3.2:

$=\;\;\;\{b\leftarrow,\;\;c\leftarrow\}$  $=\;\;\;\{a\leftarrow\:not\:b,\;\;a\leftarrow\:not\:c\}$ . 
$$P_{1}$$
$$P_{2}$$
P2 has two 3-valued answer sets ({a}, {b}) and ({a}, {c}). Again, {a} **is a (standard)** answer set for P2**, but it depends on, at minimum, the assumption of either** b or c being false by default. This in turn requires a commitment to the falsity of one of b or c in next considering P1. As a result, the 3-valued answer set ({a}, {b}**) yields the** program P
r 1 given by {c ←, a ←, ⊥ ← b}**, while the 3-valued answer set (**{a}, {c})
yields the program {b ←, a ←, ⊥ ← c}**. Consequently for the revision we obtain**
two 3-valued answer sets ({a, c}, {b}) and ({a, b}, {c}**), with corresponding answer** sets {a, c} and {**a, b**}.

For Example 3.3, where P1 = {b ←} and P2 = {a ← b}**, we obtain:**

$$\begin{array}{l l l}{{P_{2}^{r}\;=\;P_{2},}}&{{\qquad}}&{{X_{2}\;=\;(\emptyset,\emptyset)}}\\ {{P_{1}^{r}\;=\;\{b\gets\}\cup\{a\gets b\},}}&{{\qquad X_{1}\;=\;(\{a,b\},\{\}).}}\end{array}$$

Thus there is one 3-valued answer set, ({a, b}, ∅), with answer set {**a, b**}.

We consider two more small examples to further illustrate the approach.

$$\begin{array}{r c l}{{P_{1}}}&{{=}}&{{\{a\leftarrow,\enspace b\leftarrow\}}}\\ {{P_{2}}}&{{=}}&{{\{\bot\gets a,b\}}}\end{array}$$
