For P1 ∗P2, there are two 3-valued answer sets, ({a}, ∅), ({b}, ∅**) with corresponding** answer sets {a}, {b}. This is what would be desired: P2 requires that a and b **cannot**
be simultaneously true, while P1 states that a and b **are both true. In this case,** P2 is retained, with a "maximal" part of P1 **also held. Last, consider:**

$$\begin{array}{r c l}{{P_{1}}}&{{=}}&{{\{a\leftarrow,\ \ d\gets b\}}}\\ {{P_{2}}}&{{=}}&{{\{b\leftarrow\,n o t\ a,\ \ c\leftarrow\ n o t\ \neg a\}}}\end{array}$$

In this case, P2 has three-valued answer set ({b, c}, {a, ¬a}**); hence the derivation**
of b and c relies on the possibility of a being true, and of a **being false. There is one** 3-valued answer set for P1 ∗ P2, ({b, c, d}, {a, ¬a}), with answer set {**b, c, d**}.

## 4.2 Properties

Section 2.2 noted that four of the basic AGM postulates are appropriate in a nonmonotonic framework. With respect to these postulates, we obtain the following:
Theorem 4.1 Let P1, P2, P3 **be logic programs.**
(A ∗ 1) AS(P1 ∗ P2) ⊆ 2 L.

(A ∗ 2) If X ∈ AS(P2) then there is X′ ∈ AS(P1 ∗ P2**) such that** X ⊆ X′.

(A ∗ 5a) AS(P1 ∗ P2) = L iff AS(P2) = L
(A ∗ 5b) AS(P1 ∗ P2) = ∅ iff AS(P2) = ∅
(A ∗ 6) If P2 ≡s P3 then AS(P1 ∗ P2) = AS(P1 ∗ P3).

Proof (A ∗ 1) is a direct consequence of Definition 4.5. (A ∗ **2) follows from the fact**
that if X ∈ AS(P2) then there is a three-valued answer set (**X, Y** ) ∈ 3AS(P2),
and that P1 ↓ (P2 ∪ P gm((X, Y **))) by definition has an answer set. Similarly, for**
(A ∗ 5a) we have that if AS(P2) = L then AS(P1 ∗ P2) = L**, and if** AS(P2) 6= L
then AS(P1 ∗ P2) 6= L, both following directly from Definition 4.3. (A ∗ 5b**) follows**
analogously.

For (A ∗ 6) we have, in outline: By assumption we have that P2 ≡s P3**, and**
so for any program R, P2 ∪ R ≡s P3 ∪ R**. In particular, let** X ∈ 3AS(P2**). Then**
P2 ∪ P gm(X) ≡s P3 ∪ **P gm**(X).

We next make use of the small result: If P ≡s P
′then for program R and S ∈ R ↓ P **we have that there is** S
′ ∈ R ↓ P
′such that AS(S) = AS(S
′**). The**
proof of this claim is straightforward: Let S ∈ R↓P. S is of the form R′ ∪ P **where**
R′ ⊆ R**. We have that** R′ ∪ P ≡s R′ ∪ P
′**since** P ≡s P
′**. So for** S
′ = R′ ∪ P
′ we have that S
′ ∈ R↓P
′**; as well,** S ≡s S
′ and so AS(S) = AS(S
′).

So, consider again X ∈ 3AS(P2). We have that P2 ∪ P gm(X) ≡s P3 ∪ **P gm**(X)
and so, applying the above small result we have that for S ∈ P1 ↓ (P2 ∪ **P gm**(X))
there is S
′ ∈ P1 ↓(P3 ∪P gm(X)), such that AS(S) = AS(S
′**), and so if follows that**
AS(P1 ∗ P2) = AS(P1 ∗ P3).