Thus the result of revision is a set of answer sets (A ∗ **1), which is to say, if**
an agent's beliefs are given by a set of answer sets corresponding to potential states of the world, then a revision sequence also yields a set of such beliefs. The key property of the approach is given by (A ∗ **2), corresponding to the success**
postulate: in a revision P1 ∗ P2, beliefs as expressed in P2 **override those of** P1.

The two parts of (A ∗ **5) hold by virtue of the fact that in a revision** P1 ∗ P2, only some consistent (with P2) subset of P1 is used in the revision. (A ∗ **6) is**
a version of independence of syntax. The postulate fails if P2 ≡s P3 **is replaced**
by P2 ≡u P3 or AS(P2) = AS(P3**): a counterexample is given by** P1 = {b ←},
P2 = {a ← not b}**, and** P3 = {a ← not c}**. Consequently, appropriate versions of**
the core AGM postulates hold in the approach.

With regards to the postulates given in Section 2.3 for logic program updates, we obtain the following. Theorem 4.2 Let P1, P2, P3 **be logic programs.**
Then P1, P2, P3 **satisfy** initialisation, idempotency**, and** non-interference.

As well, we obtain:
SAbsorption: if P2 ≡s P3 then AS(P1 ∗ P2 ∗ P3) = AS(P1 ∗ P2).

These principles are elementary but nonetheless desirable. As mentioned, most approaches to update logic programs fail to satisfy tautology**, and in fact they generally**
do so when a revised program is inconsistent. The present approach also fails to satisfy tautology**, and in the same situation, but in this case the lack of this principle is intended:** tautology is incompatible with (A ∗ 5) and (A ∗ **6) in the case that**
the revised program is inconsistent. Note that it is straightforward to modify the approach so that tautology is satisfied, at the expense of (A ∗ 5) and (A ∗ **6), by the**
simple expedient of modifying Definition 4.5, Part 2, to be

## 2. X Is An Answer Set For P1 ∪ P2 ∪ **P Gm**(X2).

The remaining principles listed in Section 2 can be argued to be undesirable, with the possible exception of associativity**. Not surprisingly,** absorption **fails at the**
level of answer sets, though not at the level of strong equivalence (as given by **SAbsorption**). Augmentation **would seem to be related to a notion of monotonicity,**
and hence is undesirable. Disjointness and parallelism **both clearly fail. Arguably**
both should fail; consider the the case where P2 = ∅**. Disjointness in this situation**
reduces to:
AS(P1 ∗ P3) = AS(P1 ∗ P3) ∪ AS(P3)
which is clearly undesirable.

Implementation **A prototype implementation has been written in C (Tasharrofi 2009),**
and making use of the solver clasp **(Gebser et al. 2007). The prototype is at an**
early stage of development, and results concerning benchmarks or scalability have not yet been obtained.