
## 5 Discussion

This paper has described an approach to logic program revision in which the focus is on revision **as understood in the belief revision community. Consequently, the key**
success **postulate is taken seriously. The intuition is that a logic program represents**
an agent's epistemic state, while the answer sets are a representation of the agent's contingent beliefs. This leads to an approach with quite different properties than other approaches that have appeared in the literature. In particular, for a revision P1 ∗ P2 the program P2 is treated as a whole as having higher priority than P1**, in** that answer sets of P2 are propagated to P1**. This has an important consequence,**
and requires the use of three-valued interpretations, in that literals assumed to be false at a higher ranked program can override literals used as facts **in a lower-ranked** program. This is in contrast to logic program update, where one selects rules to apply, giving preference to rules in P2**, and then applies these selected rules.**
Arguably the approach helps cast light on the logic-program-update landscape.

We have suggested that update logic program **approaches are more appropriately**
viewed as dealing with preferences or priorities over rules, rather than revision or update per se. The approach at hand seems to fall somewhere between a syntactic approach and a semantic one, such as (Delgrande et al. 2008). The **answer sets** obtained exhibit reasonable properties - for example, the core AGM **postulates are** satisfied, including syntax independence under strong equivalence **and a success** postulate; and the appropriate set of logic program update postulates are also satisfied. The approach would seem to have some hope for practical implementation.

A prototype implementation is available. At present it is essentially a "proof of concept" and is a subject of current investigation.

Applicability and Evaluation of the Approach **As indicated in the introduction, a**
primary aim of this paper is to investigate the extent to which classical notions of belief revision may be applied in revising logic programs under the answer set semantics. We have claimed that the approach is intuitive**, in that it reflects plausible** notions concerning revision. In contrast to related work, it satisfies a suite of desirable formal properties. On the other hand, as with belief revision in classical logic, there is not necessarily a single best approach to logic program revision, but rather different approaches will be more or less suitable in different areas. To this end we can consider circumstances in which the present approach would be **applicable.**
It would be applicable, clearly, in a problem in which the answer sets of more recent programs are to hold sway over the answer sets of lower-ranked programs.

This would be the case with program refinement **for example, where elaborations**
taking care of special cases are incorporated into an existing program. As well, the approach can be directly applied to problems involving a sequence of NP complete problems, for example in a situation where the solution to one problem **feeds as** input into a second. A representative example described earlier involves finding a three colouring for a graph, and then finding a Hamiltonian path on the vertices of a specific colour.

These considerations also suggest the following revision methodology. A logic