program will most often be comprised of two parts, a problem instance **consisting**
of facts**, and a** problem description **consisting of rules with variables. Typically the**
facts will be of highest importance - thus in the example of finding a Hamiltonian path among yellow-coloured vertices, one would not want to revise the underlying graph. Hence any **approach to logic program change will want to isolate portions of**
the knowledge base (usually the problem instance) as being incontrovertible. It is a strength of the present approach that this can already be effected in an application, since if the facts are given as the first revising program in a sequence, the success postulate guarantees that the facts will not be modified.

Future work **There has been little work on logic program change with respect to**
disjunctive logic programs. A major reason for this is that most approaches to update logic programs focus on rules with conflicting heads. In a disjunctive program, it is not immediately clear what it means for two rules to have conflicting **heads.**
Consequently it isn't obvious how approaches to update logic programs can be extended to deal with disjunction in the head. An obvious extension to **the present**
approach then is to apply it to disjunctive programs. The key issue is **to extend the** definition of a three-valued interpretation to disjunctive rules. There seems to be no barrier to such an extension, and this would seem to be a useful yet **(presumably)** straightforward extension.

A more difficult problem is to define revision so that the result of a revision is a single logic program expressed in the language of the revising programs. That is, intuitively and ideally, the result of P1 ∗ . . . ∗ Pn **should be a logic program** P,
expressed in the language atom(P1) ∪ **. . .** ∪ atom(Pn**). (That is, auxiliary atoms**
would be expressly forbidden.) Arguably this **is the real problem of revision in**
logic programs, and there has been no substantial progress in this **area due to its** difficulty. The present approach may allow insight into how such an approach to revision can be carried out. In fact, it already allows the formation of single logic program that can be considered as a candidate for the revision P1 ∗ . . . ∗ Pn**. We**
have the result:

## Theorem 5.1

Given the assumptions and terms of Definition 4.4 where (X
+
1
, X−
1
) is a 3-valued answer set of P1 ∗ . . .∗Pn **we have that:** X
+
1 is an answer set of P
r 1 ∪P
r 2 ∪**. . .**∪P
r n
.

Note that P
r n = Pn **and so the highest-ranked program is retained, along with other**
rules from remaining programs that aren't excluded by higher-ranked programs.

Hence, we can use the approach to obtain a single program from a sequence of programs. However, this is a weak result, since the above result guarantees only that a single answer set of Pn **will be retained in the program resulting from the** revision P1 ∗ . . . ∗ Pn**. Hence one obtains a very credulous revision operator, in**
that many potential answer sets are ruled out. It may be that the **set of programs**
obtained according to Theorem 5.1 can be merged **into a single program, but this**
task in turn requires a nuanced approach to merging logic programs.