
## 2 Background 2.1 Formal Preliminaries

Our language is built from a finite set of atoms P = {a, b, . . .}**. A literal is an atom** a or its negation ¬a; L is the set of literals. For a set X of literals, not(X) = {**not a** | a ∈ X}**. For a literal** l, not l **is sometimes referred to as a naf (negation as failure)**
literal or weakly negated literal. For l ∈ L, atom(l**) is the atom corresponding to** l; for a set X of literals, atom(X) = {atom(l) | l ∈ X}. A rule r **is of the form**
L0 ← L1**, . . . , L**n, not Ln+1**, . . . ,** not Lm (1)
where L0, . . . , Lm are literals and 0 ≤ n ≤ m. If n = m **then** r is positive**. If**
m = 0, then r **is called a** fact. We also allow the situation where L0 **is absent, in**
which case we denote the head by ⊥; and r **is called a** constraint**. The literal** L0 is called the head of r, and the set {L1**, . . . , L**n, not Ln+1**, . . . ,** not Lm} **is the** body of r**. We use** head(r) to denote the head of rule r**, and** body(r**) to denote the body**
of r**. Furthermore,** body+(r) = {L1, . . . , Ln} and body−(r) = {Ln+1**, . . . , L**m}. An
(extended) logic program**, or simply a** program**, is a finite set of rules.**
A set of literals X is consistent **if it does not contain a complementary pair** a,
¬a of literals and does not contain ⊥**. We say that** X is logically closed **iff it is**
either consistent or equals L**. The smallest set of literals being both logically closed**
and closed under a set P of positive rules is denoted by Cn(P**). The** reduct, P
X,
of P relative to a set X **of literals is defined by** P
X = {head(r) ← body+(r) | r ∈ P, body−(r) ∩ X = ∅} (Gelfond and Lifschitz 1990). A set X **of literals is an**
answer set **of a logic program** P if Cn(P
X ) = X**. The set of answer sets of program**
P is denoted by AS(P). A program P **is consistent just if it has an answer set not**
equal to L**. Thus a program with no answer sets is also counted as inconsistent.**
For example, the program P = {a ←, b ← a, not **c, c** ← not b} **has answer sets**
AS(P) = {{a, b}, {**a, c**}}.

Two programs P1 and P2 are equivalent, written P1 ≡ P2**, if both programs have**
the same answer sets. Two programs are strongly equivalent (Lifschitz et al. 2001),
written P1 ≡s P2, just if P1 ∪ P3 ≡ P2 ∪ P3 **for every logic program** P3.

## 2.2 Belief Revision

Belief revision **is the area of KR that is concerned with how an agent may incorporate new information about a domain into its knowledge base. In belief revision,**
a formula α is to be incorporated into the agent's set of beliefs K**, so that the**
resulting knowledge base is consistent when α is. Since α **may be inconsistent with**
K, revision may also necessitate the removal of beliefs from K **in order to retain**
consistency. By a principle of informational economy, as many beliefs as possible are retained from K**. A common approach in addressing belief revision is to** provide a set of rationality postulates **for belief change functions. The** AGM approach **(Alchourr´on et al. 1985; G¨ardenfors 1988) provides the best-known set of**
such postulates. An agent's beliefs are modelled by a set of sentences, called a belief