set**, closed under the logical consequence operator of a logic that includes classical**
propositional logic.

Subsequently, various researchers have argued that it is more appropriate to consider epistemic states as objects of revision. An epistemic state K **effectively**
includes information regarding how the revision function itself changes following a revision. The belief set corresponding to epistemic state K is denoted Bel(K). Formally, a revision operator ∗ maps an epistemic state K **and new information** α to a revised epistemic state K ∗α. For set of formulas Ψ, define Ψ +α as Cn(Ψ∪ {α}).

Then, the basic AGM postulates for revision can be given as follows:
(K ∗ 1) Bel(K ∗ α) = Cn(Bel(K ∗ α))
(K ∗ 2) α ∈ Bel(K ∗ α) (K ∗ 3) Bel(K ∗ α) ⊆ Bel(K) + α (K ∗ 4) If ¬α /∈ Bel(K) then Bel(K) + α ⊆ Bel(K ∗ α)
(K ∗ 5) Bel(K ∗ α) is inconsistent, only if ⊢ ¬α
(K ∗ 6) If α ≡ ψ then Bel(K ∗ α) = Bel(K ∗ ψ) Thus, the result of revising K by α is an epistemic state in which α **is believed in** the corresponding belief set (K ∗ 1, K ∗ **2); whenever the result is consistent, the** revised belief set consists of the expansion of Bel(K) by α (K ∗ 3, K ∗ **4); the only** time that Bel(K) is inconsistent is when α is inconsistent (K ∗ **5); and revision is** independent of the syntactic form of the formula for revision (K ∗**6). (As well, there**
are two extended postulates (K ∗ 7) and (K ∗ 8) that extend (K ∗ 3) and (K ∗ **4) to**
relating revision by a conjunction and the individual conjuncts. Like (K ∗ **3) and**
(K ∗ **4) they are are not appropriate in a nonmonotonic framework (below) and we**
do not consider them further.)
Belief revision is usually expressed with respect to an underlying logic governed by a Tarskian consequence operator. It can be observed that two of the postulates, (K∗ 3) and (K ∗**4), are inappropriate in a system governed by a notion of nonmonotonic** consequence. As an example, consider where the agent believes that a particular individual is a bird and that it can fly. If it is subsequently learned that **the bird was** a penguin, the agent would also modify its knowledge base so that it believed that the individual did not fly. This example then violates both (K ∗3) and (K ∗**4). Note** that we can't circumvent this counterexample by simply excluding states of affairs where there are no flying penguins, since we would want to allow the possibility that a penguin (perhaps an extremely fit penguin) flies, even though penguins, by default, do not fly. In consequence we focus on postulates (K ∗ 1), (K ∗ **2), (**K ∗ 5)
and (K ∗ **6), which we refer to as the** core **AGM postulates.**
Note that nonmonotonic formalisms can nonetheless be treated from the standpoint of classical (AGM) revision; the issue is to express revision in terms of a monotonic foundation. Thus (Delgrande et al. 2008) addresses revision **in ASP from the**
standpoint of the SE models **of a program. This is in contrast to the work here, and**
previous work, which addresses belief change at the level of a logic program rather than with respect to the underlying models.

Various revision operators have been defined; see (Satoh 1988; Williams 1995; Delgrande and Schaub 2003) for representative approaches. Perhaps the best known