approach is the Dalal revision operator **(Dalal 1988). This operator is defined as**
follows. Let ψ, µ be formulas of propositional logic, and let ⊖ be the symmetric difference of two sets. Then the Dalal revision ψ ∗d µ **is characterised by those models**
of µ that are closest to models of ψ**, where the notion of closeness is given by the**
Hamming distance between interpretations. Formally, ψ ∗d µ**, is defined as follows.**
For formulas α and β**, define:**
|⊖|min(**α, β**)def = min≤({|w ⊖ w
′| | w ∈ Mod(α), w′ ∈ Mod(β)}).

Then, Mod(ψ ∗d µ**) is given as**
{w ∈ Mod(µ) | ∃w
′∈Mod(ψ**) s.t.** |w ⊖ w
′| = |⊖|min(**ψ, µ**)}.

## 2.3 Logic Program Updates

Previous work in ASP that addresses an agent's evolving knowledge base has generally been termed logic program update or update logic programs**. In such approaches**
one begins with an ordered logic program**, comprised of a sequence of logic programs**
(P1, . . . , Pn**). Rules in higher-ranked sets are, in some fashion or another, preferred**
over those in lower-ranked sets. Commonly this is implemented by using the ordering on rules to adjudicate which of two rules should be applied when both are applicable and their respective heads conflict; see for example (Inoue and Sakama 1999; Alferes et al. 2000; Eiter et al. 2002). Alternatively, other approaches use the ordering to "filter" rules, e.g. (Zhang and Foo 1998). Hence, in one fashion or another, some rules are selected over others, and these selected rules are **used to determine** the resulting answer sets.

A major stream of research in ASP has addressed prioritised or preference **logic**
programs, where a prioritised logic program is a pair (P, <) in which < is an ordering over rules in program P**. The intuition is that some rules take precedence**
over (or override or are more important than) other rules. Syntactically, the form of an update logic program, given as a total order on programs, is of course an instance of a prioritised logic program. We suggest that an update logic program is in fact best regarded as a prioritised logic program. (Indeed some **approaches**
to updating logic programs are defined in terms of a prioritised logic program
(Foo and Zhang 1997; Zhang and Foo 1998).) This is most clearly seen **in those**
approaches where the focus is on rules whose heads conflict. Thus, for example in the approach of (Eiter et al. 2002), preferences come into play only between two rules when the head of one is the complementary literal of the other. The following example, due to Patrick Kr¨umpelmann, is illuminating:
P1 = {b ←}, P2 = {¬a ← b}, P3 = {a ←}
In update logic programs, the rule in P2 **is dropped, since its head conflicts with** the higher-ranked rule in P3. Yet dropping the rule in P1 **yields a consistent result.**
Moreover, since it is the lowest-ranked rule, arguably it should **be disregarded.**
We can summarise the preceding by suggesting that previous work is **essentially**
based at the rule level, in that higher-ranked rules preempt lower-ranked rules. In