contrast, the approach here is based at the program level**; that is for a revision**
P1 ∗ P2, the program P2 **is considered** as a whole to have priority over P1**, in that**
program P2's answer sets in a sense have priority over those of P1**. This is effected**
in a revision P1 ∗P2 by first determining answer sets of P2**, and then augmenting, as** appropriate, these answer sets with additional information via P1**. (There is more to** it than this, as described in the next section. For example, rules in P1 **may result in** other rules in P2 **being applied. However the essential point remains, that the answer** sets of P1 **are first determined, and then subsequently augmented.) Arguably this is** the appropriate level of granularity for revision: If an agent learns new information given in a program P**, it is the program** as a whole **that comprises the agent's (new)**
knowledge. That is, a rule r ∈ P **isn't an isolated piece of knowledge, but rather,**
given possible negation as failure literals in body(r**), the potential instantiation of**
r **depends non-locally on the entire program** P.

(Eiter et al. 2002) suggests a number of alternative postulates that may be considered for update program updates. For our use, they are given **as follows:**

Initialisation: AS(∅ ∗ P) = AS(P). Idempotency: AS(P ∗ P) = AS(P).
Tautology: If head(r) ∈ body+(r), for all r ∈ P2**, then**
AS(P1 ∗ P2) = AS(P1). Absorption: if AS(P2) = AS(P3) then AS(P1 ∗ P2 ∗ P3) = AS(P1 ∗ P2). Augmentation: If AS(P2) ⊆ AS(P3), then AS(P1 ∗ P2 ∗ P3) = AS(P1 ∗ P3). AS((P1 ∪ P2) ∗ P3) = AS(P1 ∗ P3) ∪ AS(P2 ∗ P3). AS(P1 ∗ (P2 ∪ P3)) = AS(P1 ∗ P2) ∪ AS(P1 ∗ P3). AS(P1 ∗ P2 ∗ P3) = AS(P1 ∗ P3 ∗ P2).
Associativity: AS(P1 ∗ (P2 ∗ P3**)) =** AS((P1 ∗ P2) ∗ P3).
Disjointness: If atom(P1) ∩ atom(P2) = ∅**, then**
Parallelism: If atom(P2) ∩ atom(P3) = ∅**, then**
Non-Interference: If atom(P2) ∩ atom(P3) = ∅**, then**
Many of these postulates are elementary and expected, yet most **extant approaches**
have problems with them. In particular, most approaches do not satisfy tautology and so for instance the addition of a rule p ← p **may produce different results. Moreover, those that do satisfy** tautology **most often do so by specifically addressing this**
principle. It seems reasonable to suggest that the reason for this **lack of adherence** to basic postulates is that belief change with respect to ASP is a program-level operation, and not a rule-level operation.

## 3 Logic Program Revision: Intuitions

The overall goal is to come up with an approach to revision in logic programs (call it LP revision**) under the answer set semantics, where the approach adheres insofar**
as possible to intuitions underlying classical (AGM) revision. In essence, a major goal is to examine the extent to which the AGM approach may be applied with respect to answer set programming. As described earlier, we take a logic program