P **as specifying an agent's** epistemic state. The answer sets of P, AS(P**), represent**
the beliefs of the agent, and so are analogous to a belief set in AGM revision.

A key characteristic of AGM revision, and one that guides the approach here, is the success postulate**. Recall that in the AGM approach, the success postulate**
stipulates that α ∈ Bel(K ∗ α**), or in terms of models, that** Mod(Bel(K ∗ α)) ⊆
Mod(α). Informally, in a revision by α, the logical content of α **is retained. By**
analogy with the success postulate, for a revision of P1 by P2**, the content of** P2 is given by its answer sets, and so in the revision P1 ∗P2, the answer sets of P2 **should**
in some sense be contained in those of P1 ∗ P2**. This notion is fundamental; as well,** it has very significant ramifications in an approach to LP revision.

For example, consider the following programs, where we want to determine P1∗P2:

## Example 3.1

$$b\leftarrow,$$

## P1 = {B ←, C ← Not D}

$=\;\;\;\{a\gets not\;b\}$ . 
$$P_{2}$$
By our interpretation of the success postulate, since {a} **is an answer set of** P2, it should appear in the answer sets of P1 ∗ P2 (that is, {a} **should be a subset of** some answer set of P1 ∗ P2). However, a **was derived by the failure of being able** to prove b in P1. Consequently, if the answer sets of P2 **are to appear among the**
answer sets of P1 ∗ P2**, then the** reasons for the answer sets of P2 **should also be**
retained. Consequently b should not appear in the answer sets of P1 ∗ P2**. Hence** we would want to obtain {a, c} as the answer set of P1 ∗ P2**. This example serves**
to distinguish the present approach from previous work, in that in previous work the assertion of a fact overrides an assumption of negation as failure at any level. Thus in previous work on update logic programs for the above example one would obtain the answer set {**b, c**}.

So adherence to a success postulate requires that, if a literal not p **is used in a**
higher-ranked set of rules, it should override positive occurrences in lower-ranked sets. This also is in keeping with our assertion in the previous section, **that in a** revision we consider a program as a whole, and not at the individual rule level.

However, it might plausibly be objected that often one wants to retain facts (such as b in P1), and so such facts should obtain in the revision P1 ∗ P2**. We suggest**
instead that in such an instance, such (protected) facts should in **fact be given**
higher priority. We return to this point in Section 5, where we discuss **the notion**
of a revision methodology.

In working towards an answer set for a revision P1 ∗ P2**, we first determine an**
answer set for P2**. However, we need to keep track of not just those literals that are** (positively) derivable, but also a set of not **literals necessary for the construction** of the answer set. Consequently, we deal with three-valued answer sets. Thus for Example 3.1, in considering P1, we need to keep track of the fact that a **was derived**
in P2 **and that moreover** not b **was used in this derivation, thereby necessitating**
the blocking of any later deriving of b in lower ranked rule sets. We write the three