# An Empirical Study Of Borda Manipulation

Jessica Davies, George Katsirelos, Nina Narodytska and Toby Walsh

## Abstract

We study the problem of coalitional manipulation in elections using the unweighted Borda rule. We provide empirical evidence of the manipulability of Borda elections in the form of two new greedy manipulation algorithms based on intuitions from the bin-packing and multiprocessor scheduling domains. Although we have not been able to show that these algorithms beat existing methods in the worst-case, our empirical evaluation shows that they significantly outperform the existing method and are able to find optimal manipulations in the vast majority of the randomly generated elections that we tested. These empirical results provide further evidence that the Borda rule provides little defense against coalitional manipulation.

## 1 Introduction

Elections are a well established mechanism to aggregate the preferences of individuals to reach a consensus decision. New applications of voting and social choice have emerged in the field of multiagent systems and are used on a daily basis by many people in the form of polls and ratings systems on the internet. As an election is meant to be a fair way of reaching a decision, it is important to study the weaknesses of different voting systems with respect to their vulnerability to manipulation, bribery and control. In this paper we focus on the manipulation problem, where a coalition of agents votes to ensure a desired outcome rather than reporting their true preferences. It is assumed that the manipulators act with full knowledge of the votes of the remaining electorate, but even so, the structure of the voting system may make it difficult to ensure that the desired candidate wins. No practical voting system can prevent a coalition of enough manipulators from achieving their goal in all elections. However, some mechanisms may be easier to manipulate than others. For example, the required size of the coalition may be impractical, especially in real-world settings where obtaining the cooperation of and coordinating more than two or three people can be difficult. Even if the number of extra votes isn't a concern, calculating the required set of manipulator votes may be computationally infeasible.

In this work we study the voting system based on using the Borda rule to aggregate the votes.

The Borda rule is a positional scoring rule proposed by the French scientist Jean-Charles de Borda in 1770. Like all positional scoring rules, each voter simply ranks the m candidates according to their preference. The votes are aggregated by adding a score of m − k to a candidate for each time it appears k th in a vote. The candidates with the highest aggregated score win the election. The simplicity of this rule may have contributed to its independent reinvention on at least one other occasion; political elections in two Pacific island states use slight modifications of the Borda rule [11]. It is also commonly used in competitions such as the Eurovision song contest, the election of the Most Valuable Player in major league baseball, and the Robocup competition.

The susceptibility of Borda elections to manipulation has been strongly suggested by recent theoretical work. Although the problem is NP-hard if the manipulators' votes are weighted [6], in the unweighted case the complexity class is still frustratingly unknown. Xia et al. observe that:
"The exact complexity of the problem [coalition manipulation with unweighted votes] is now known with respect to almost all of the prominent voting rules, with the glaring exception of Borda" [17]