LSLA(V,n)
1. B[i] ← ∅ for all 1≤i≤m
// B[d] is filled with n m-1's 2. B[d] ← {m-1,...,m-1}
// Each score is repeated n times in S
3. S ← {m-2,...,m-2,m-3,...,m-3,...,1,...,1,0,...,0}
4. *while* S 6= {}
// The column of B with highest average desired score 5. c ← argmax i{ [g_i-sum(B[i])] / [n-|B[i]|]] : |B[i]| < n}
6. s ← chooseScore(g_c-sum(B[c]), S)
7. B[c].push(s)
8. S ← S - {s}
9. if sum(B[d]) + s(V,d) ≥ max i{sum(B[i]) + s(V,i)}
10. return B
11.*else* 12. return Failure chooseScore(g,S)
1. s ← max{s ∈ S : s ≤ g}
2. if s = None 3. s = S[0] 4. return s Figure 5: The greedy algorithm based on average desired score, for n manipulators.

until either it runs out of 1's or B[2] is filled. In fact, the 1's will run out before B[2] is filled, since B[2] requires n−(
n−k 2 +
n−k 2 +k/3+6) = 2k/3−6 more elements, which is equal to the number of remaining 1's, but these are spread between B[1] and B[2]. So B[2] will get (2k/3−6)/2 = k/3−3 additional 1's, for a total of sum(B[2]) = 4k + 2( n−k 2) + n−k 2 + k/3 + 6 + k/3 − 3 = 19k/3 −
3 > 19k/3 − 12 = 3n. Since sum(B[2]) > 3n there is no manipulation using n = 19k/9 − 4 manipulators. Therefore, LSLG requires at least n + 1 = 2k + k/9 − 3 manipulators. ✷
This result shows the weakness of LSLG, that it only considers the relative sizes of the competing candidates' current scores. Therefore if two candidates' column sums ever become equal during LSLG, they will often be treated equivalently for the remainder of the iterations. In the example from Theorem 3.2, this is the fatal mistake, since at the point where sum(B[3]) becomes equal to sum(B[2]), column 3 requires fewer additional elements before it is filled (i.e. |B[2]| < |B[3]|).

Therefore, it is important for column 3 to receive larger elements than column 2. In fact, all of the largest elements must be taken by column 3, and none given to column 2. However, LSLG will begin treating the two equal columns the same, distributing the remaining 2's evenly between B[2] and B[3]. This observation motivates our second greedy algorihthm.

## 3.2 Average Desired Score

The second greedy algorithm is based on the idea that it is not enough to simply assign the largest scores to the columns of B that have the largest gap. Each column of B also requires exactly n elements in order to be filled, where n is the number of manipulators currently attempted. To balance these two requirements, we can look at the remaining gap gi − sum(B[i]) and divide it by the remaining number of scores that must be added to column i, n − |B[i]|. Notice that if we had n − |B[i]| scores of this average size available (for each i), we could fill every column of B
perfectly. Since we don't, a sensible heuristic is to put the largest scores in the columns that have