It is worth noting that none of the above approaches is able to find *optimal* **plans, i.e., plans that** minimise the resource consumption. Other well known automatic planners indeed address this issue. In particular, the TM-LPSAT tool [5] works only on linear domains. This is also the case of the UPPAAL/TIGA tool [6], [19] that, being built on top of UPPAAL, allows one to use real variables only as clocks (i.e., real variables can be modelled only if their first derivative is 1), thus excluding systems with nonlinear dynamics. Finally, the MIPS planner [7], being based on symbolic model checking, does not perform well on hybrid nonlinear systems. Therefore, automatic optimal planning with resource consumption on hybrid, nonlinear systems such as rovers is still an open issue. 

## 3. Planning Through Explicit Model C**Hecking**

Model checking algorithms are typically divided in two categories: symbolic algorithms (e.g., 
[20]) and explicit algorithms (e.g., [21]). Symbolic algorithms have been successfully applied to classical planning [7,22], however they do not work well on hybrid systems with nonlinear dynamics, due to the complexity of the state transition function [23]. Therefore, explicit model checking performs better with the kind of systems we intend to approach. Also these algorithms are subject to the well-known state explosion problem: however, the ability to build the system transition graph on demand and generate only the reachable states of the system (through the reachability analysis), together with many space saving techniques (see, e.g., [24]), help to mitigate it. 

Generally speaking, given a set  of error states and a set - of *initial states* **for a system, an** 
explicit model checker incrementally generates all the valid system states *(reachable states)*, 
starting from the ones in - and repeatedly applying the *transition function* **that describes the** system dynamics. If a state    **is encountered, the model checker outputs the sequence of** states *(error trace)* **that leads to** . 

If we look at error states as *goal states***, we can use a model checker as a planner. This very** 
simple fact allows one to use the model checking technology to automatically synthesise optimal plans for complex systems. 

## 3.1. **Planning Of Finite State Systems**

A hybrid system [25] is a system whose state description involves continuous as well as discrete variables. In order to apply model checking algorithms and exploit the reachability analysis, the system should have a finite number of states. To this aim, we approximate the system by discretising the continuous components of the state (which we assume to be bounded) and their dynamic behaviour. For lack of space, we cannot describe here the approximation process, however the reader can see how our approach works by looking at the case study in Section 4. 

In the following we first give a formal definition of the approximated model, **the finite state** system**, and then describe how the planning problem can be solved for such kind of system.** 
Definition 1 (Finite State System) A Finite State System (FSS)  is a 4-tuple , 	**, ,** , 
where:  is a finite set of states, 	   is the initial state,  **is a finite set of actions and** 
:       0,1 is the transition function, i.e. 	, , 	
  1 **iff the system from state** can reach state 	 **via action** . By abuse of language, we denote with 	,  the successor state of 	 through action **, i.e. the** 
state 	 so that 	**, ,** 	  1. 

In order to define the planning problem for such a system, we assume that a set of *goal states*
   has been specified. Moreover, to have a finite state system, we fix a **finite temporal** 
horizon  and we require a plan to reach the goal in at most  actions. Note that, in most 