Moreover, the rover has limited communication and computation resources, so it must be programmed with a detailed plan of activity and then left operating, without any chance to recover from an error or recompute its mission. If something wrong or unexpected happens, the best that the rover can do is to stop, reset and wait for the next Earth connection to get new instructions. 

The plan we want to generate does not address the actual route of the rover, but controls the vehicle engine and instruments during the route itself. Routing is a different problem, so just we assume that a (possibly straight) route of length @A'&1B **has been separately planned and will be** 
used to control the steering of the rover wheels. 

When moving, the rover is subject to friction and drift due to the - often unpredictable - ground characteristics. Thus, every @C1D meters, it has to stop for EF **seconds to look at its actual** 
position and conditions, before starting again to move. These frequent stops may also be useful to ensure a proper cooling of the rover wheels and instruments, if moving in a hot environment. 

For sake of generality, in the following we shall call these stops "cooling tasks". However, we assume that the route duration be less or equal to EC1D **seconds, since the overall rover mission** 
should not exceed a reasonable limit. The rover has a base energy consumption G/ **Joule/second,** 
used to power its CPU. 

The energy (expressed in Joule/second) required to move the rover with speed H **and** 
acceleration HI can be evaluated by applying the general function J **of Equation 1, where** K **is** the vehicle mass and J **is its frontal area (see [31] for details).** 

$$f(v,\dot{v})=(\frac{1}{2}\cdot\rho\cdot v^{2}\cdot Cd\cdot fa+m\cdot g\cdot(Crr+\frac{\dot{v}}{g}))\cdot v\tag{1}$$
In the equation, constants , G **indicate the planet air density and its gravitational constant,** 
respectively, whereas @ and PP **are the drag and rolling coefficients of the rover. Finally, the** 
cooling tasks require a constant energy of GF **Joule/second.** 
The rover dynamics (i.e., the covered distance @, the speed H and the acceleration HI **) is given** 
by Equation 2. 
$$\frac{\partial v}{\partial t}=a(t)-\ \mu\cdot g\tag{2}$$ $$\frac{\partial\phi}{\partial t}=v(t)$$  where $a(t)$ is the acceleration given by the rover motor at time $t$ and $\mu$ is the kinetic friction 
coefficient for the rover wheels. 

We assume that, in each communication session, the Earth control sends to the rover a plan to drive it to the next place, and the commands needed to start the corresponding activity. Such plan consists of a sequence of actions, to be performed at 1 second intervals, chosen from the set A = {*accelerate, decelerate, continue* (moving at constant speed), perform a *cooling task*}. 

The plan must obey the following constraints: 
- the rover must not exceed the speed of HC1D **cm/s;** 
- the rover must stop every @ **meters to perform a cooling task;** 
- the rover must stop after @A'&1B **meters (to start the activity) with a residual battery charge** 
not lower than S C'& **coulomb;** 
- the rover route must not require more than EC1D **seconds.** 
In particular, we must ensure that, after moving to the given location, the rover has still enough battery charge available for its activity. 