
## 4.2. Rover Modelling

The dynamics and constraints given above can be compactly and precisely illustrated through

the hybrid automaton shown in Figure 1.

![0_image_0.png](0_image_0.png)

The state of the automaton is s = (x,q) E S, where q E {stopped, running, braking, cooling, engine blown, no energy} and x = (d, a, v, T, Tς).

The rover is initially in a stopped state, where the only energy consumption is given by g c .

When started, the rover enters the running state and moves as described by Equation 2 while its energy consumption is increased by the value given by Equation 1. The vehicle can accelerate and decelerate with steps of 1.5 cm/s 2 . After d meters, the vehicle starts braking and, once stopped, it begins the cooling phase, with the corresponding energy consumption. After 6 seconds of cooling ( T c in the automaton), the vehicle restarts and continues in the running state.

The automaton also shows two possible failure conditions: if the rover moves faster than the max allowed speed v max , its engine blows up ( engine blown state): in this case, the entire mission could fail. On the other hand, if the consumed energy exceeds the limit c min , the rover stops (no energy state) , using the residual energy to wait for Earth instructions. We fixed the model constants to the values given in Table 1, most of which are obtained from rover specifications like [2] and [1]. Note that we assume that the rover operates on the Mars surface.