# Evaluating And Improving Modern Variable And Revision Ordering Strategies In Csps

Thanasis Balafoutis
∗,a, Kostas Stergiou a aDepartment of Information and Communication Systems Engineering, University of the Aegean, Samos, Greece

## Abstract

A key factor that can dramatically reduce the search space during constraint solving is the criterion under which the variable to be instantiated next is selected. For this purpose numerous heuristics have been proposed. Some of the best of such heuristics exploit information about failures gathered throughout search and recorded in the form of constraint weights, while others measure the importance of variable assignments in reducing the search space. In this work we experimentally evaluate the most recent and powerful variable ordering heuristics, and new variants of them, over a wide range of benchmarks.

Results demonstrate that heuristics based on failures are in general more efficient. Based on this, we then derive new revision ordering heuristics that exploit recorded failures to efficiently order the propagation list when arc consistency is maintained during search. Interestingly, in addition to reducing the number of constraint checks and list operations, these heuristics are also able to cut down the size of the explored search tree.

Key words: Constraint Satisfaction, Search heuristics, Variable ordering, Revision ordering

## 1. Introduction

Constraint programming is a powerful technique for solving combinatorial search problems that draws on a wide range of methods from artificial intelligence and computer science. The basic idea in constraint programming is that the user states the constraints and a general purpose constraint solver is used to solve the resulting constraint satisfaction problem. Since constraints are relations, a Constraint Satisfaction Problem (CSP) states which relations hold among the given decision variables. CSPs can be solved either systematically, arXiv:1008.0659v2 [cs.AI] 7 Aug 2010